// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.ModifyAuthenticationProfileResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyAuthenticationProfileOperationDeserializer: HttpDeserialize<ModifyAuthenticationProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyAuthenticationProfileResponse {
        if (!response.status.isSuccess()) {
            throwModifyAuthenticationProfileError(context, response)
        }
        val builder = ModifyAuthenticationProfileResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyAuthenticationProfileOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyAuthenticationProfileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthenticationProfileNotFoundFault" -> AuthenticationProfileNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "AuthenticationProfileQuotaExceededFault" -> AuthenticationProfileQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidAuthenticationProfileRequestFault" -> InvalidAuthenticationProfileRequestFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyAuthenticationProfileOperationBody(builder: ModifyAuthenticationProfileResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyAuthenticationProfileResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyAuthenticationProfileResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyAuthenticationProfile response")
    }
    // end unwrap response wrapper

    val AUTHENTICATIONPROFILECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AuthenticationProfileContent"))
    val AUTHENTICATIONPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AuthenticationProfileName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifyAuthenticationProfileResult"))
        field(AUTHENTICATIONPROFILECONTENT_DESCRIPTOR)
        field(AUTHENTICATIONPROFILENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONPROFILECONTENT_DESCRIPTOR.index -> builder.authenticationProfileContent = deserializeString()
                AUTHENTICATIONPROFILENAME_DESCRIPTOR.index -> builder.authenticationProfileName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
