// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeOfferingsResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ReservedNodeOffering
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class GetReservedNodeExchangeOfferingsOperationDeserializer: HttpDeserialize<GetReservedNodeExchangeOfferingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetReservedNodeExchangeOfferingsResponse {
        if (!response.status.isSuccess()) {
            throwGetReservedNodeExchangeOfferingsError(context, response)
        }
        val builder = GetReservedNodeExchangeOfferingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetReservedNodeExchangeOfferingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetReservedNodeExchangeOfferingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidReservedNodeState" -> InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeAlreadyMigrated" -> ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReservedNodeExchangeOfferingsOperationBody(builder: GetReservedNodeExchangeOfferingsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetReservedNodeExchangeOfferingsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetReservedNodeExchangeOfferingsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetReservedNodeExchangeOfferings response")
    }
    // end unwrap response wrapper

    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val RESERVEDNODEOFFERINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ReservedNodeOfferings"), XmlCollectionName("ReservedNodeOffering"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("GetReservedNodeExchangeOfferingsResult"))
        field(MARKER_DESCRIPTOR)
        field(RESERVEDNODEOFFERINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                RESERVEDNODEOFFERINGS_DESCRIPTOR.index -> builder.reservedNodeOfferings =
                    deserializer.deserializeList(RESERVEDNODEOFFERINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedNodeOffering>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedNodeOfferingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
