// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsWithIamResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetClusterCredentialsWithIAMOperationDeserializer: HttpDeserialize<GetClusterCredentialsWithIamResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetClusterCredentialsWithIamResponse {
        if (!response.status.isSuccess()) {
            throwGetClusterCredentialsWithIamError(context, response)
        }
        val builder = GetClusterCredentialsWithIamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetClusterCredentialsWithIAMOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetClusterCredentialsWithIamError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetClusterCredentialsWithIAMOperationBody(builder: GetClusterCredentialsWithIamResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetClusterCredentialsWithIAMResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetClusterCredentialsWithIAMResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetClusterCredentialsWithIAM response")
    }
    // end unwrap response wrapper

    val DBPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DbPassword"))
    val DBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DbUser"))
    val EXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("Expiration"))
    val NEXTREFRESHTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("NextRefreshTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("GetClusterCredentialsWithIAMResult"))
        field(DBPASSWORD_DESCRIPTOR)
        field(DBUSER_DESCRIPTOR)
        field(EXPIRATION_DESCRIPTOR)
        field(NEXTREFRESHTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBPASSWORD_DESCRIPTOR.index -> builder.dbPassword = deserializeString()
                DBUSER_DESCRIPTOR.index -> builder.dbUser = deserializeString()
                EXPIRATION_DESCRIPTOR.index -> builder.expiration = deserializeString().let { Instant.fromIso8601(it) }
                NEXTREFRESHTIME_DESCRIPTOR.index -> builder.nextRefreshTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
