// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.DeleteEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.VpcEndpoint
import aws.sdk.kotlin.services.redshift.model.VpcSecurityGroupMembership
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DeleteEndpointAccessOperationDeserializer: HttpDeserialize<DeleteEndpointAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteEndpointAccessResponse {
        if (!response.status.isSuccess()) {
            throwDeleteEndpointAccessError(context, response)
        }
        val builder = DeleteEndpointAccessResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteEndpointAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteEndpointAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "EndpointNotFound" -> EndpointNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidEndpointState" -> InvalidEndpointStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteEndpointAccessOperationBody(builder: DeleteEndpointAccessResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DeleteEndpointAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DeleteEndpointAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DeleteEndpointAccess response")
    }
    // end unwrap response wrapper

    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Address"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val ENDPOINTCREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("EndpointCreateTime"))
    val ENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointName"))
    val ENDPOINTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointStatus"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("Port"))
    val RESOURCEOWNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ResourceOwner"))
    val SUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SubnetGroupName"))
    val VPCENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VpcEndpoint"))
    val VPCSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("VpcSecurityGroups"), XmlCollectionName("VpcSecurityGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DeleteEndpointAccessResult"))
        field(ADDRESS_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(ENDPOINTCREATETIME_DESCRIPTOR)
        field(ENDPOINTNAME_DESCRIPTOR)
        field(ENDPOINTSTATUS_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(RESOURCEOWNER_DESCRIPTOR)
        field(SUBNETGROUPNAME_DESCRIPTOR)
        field(VPCENDPOINT_DESCRIPTOR)
        field(VPCSECURITYGROUPS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESS_DESCRIPTOR.index -> builder.address = deserializeString()
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                ENDPOINTCREATETIME_DESCRIPTOR.index -> builder.endpointCreateTime = deserializeString().let { Instant.fromIso8601(it) }
                ENDPOINTNAME_DESCRIPTOR.index -> builder.endpointName = deserializeString()
                ENDPOINTSTATUS_DESCRIPTOR.index -> builder.endpointStatus = deserializeString()
                PORT_DESCRIPTOR.index -> builder.port = deserializeInt()
                RESOURCEOWNER_DESCRIPTOR.index -> builder.resourceOwner = deserializeString()
                SUBNETGROUPNAME_DESCRIPTOR.index -> builder.subnetGroupName = deserializeString()
                VPCENDPOINT_DESCRIPTOR.index -> builder.vpcEndpoint = deserializeVpcEndpointDocument(deserializer)
                VPCSECURITYGROUPS_DESCRIPTOR.index -> builder.vpcSecurityGroups =
                    deserializer.deserializeList(VPCSECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcSecurityGroupMembership>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcSecurityGroupMembershipDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
