// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.DeleteClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteClusterParameterGroupOperationDeserializer: HttpDeserialize<DeleteClusterParameterGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteClusterParameterGroupResponse {
        if (!response.status.isSuccess()) {
            throwDeleteClusterParameterGroupError(context, response)
        }
        val builder = DeleteClusterParameterGroupResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteClusterParameterGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterParameterGroupNotFound" -> ClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterParameterGroupState" -> InvalidClusterParameterGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
