// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.AuthorizeSnapshotAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AuthorizeSnapshotAccessOperationDeserializer: HttpDeserialize<AuthorizeSnapshotAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AuthorizeSnapshotAccessResponse {
        if (!response.status.isSuccess()) {
            throwAuthorizeSnapshotAccessError(context, response)
        }
        val builder = AuthorizeSnapshotAccessResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAuthorizeSnapshotAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAuthorizeSnapshotAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationAlreadyExists" -> AuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationQuotaExceeded" -> AuthorizationQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterSnapshotState" -> InvalidClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeSnapshotAccessOperationBody(builder: AuthorizeSnapshotAccessResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AuthorizeSnapshotAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("AuthorizeSnapshotAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap AuthorizeSnapshotAccess response")
    }
    // end unwrap response wrapper

    val SNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Snapshot"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("AuthorizeSnapshotAccessResult"))
        field(SNAPSHOT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SNAPSHOT_DESCRIPTOR.index -> builder.snapshot = deserializeSnapshotDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
