// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a cluster restore action. Returns null if the cluster was not created by restoring a snapshot.
 */
public class RestoreStatus private constructor(builder: Builder) {
    /**
     * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public val currentRestoreRateInMegaBytesPerSecond: kotlin.Double = builder.currentRestoreRateInMegaBytesPerSecond
    /**
     * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public val elapsedTimeInSeconds: kotlin.Long = builder.elapsedTimeInSeconds
    /**
     * The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public val estimatedTimeToCompletionInSeconds: kotlin.Long = builder.estimatedTimeToCompletionInSeconds
    /**
     * The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public val progressInMegaBytes: kotlin.Long = builder.progressInMegaBytes
    /**
     * The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public val snapshotSizeInMegaBytes: kotlin.Long = builder.snapshotSizeInMegaBytes
    /**
     * The status of the restore action. Returns starting, restoring, completed, or failed.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.RestoreStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreStatus(")
        append("currentRestoreRateInMegaBytesPerSecond=$currentRestoreRateInMegaBytesPerSecond,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("snapshotSizeInMegaBytes=$snapshotSizeInMegaBytes,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentRestoreRateInMegaBytesPerSecond.hashCode()
        result = 31 * result + (elapsedTimeInSeconds.hashCode())
        result = 31 * result + (estimatedTimeToCompletionInSeconds.hashCode())
        result = 31 * result + (progressInMegaBytes.hashCode())
        result = 31 * result + (snapshotSizeInMegaBytes.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreStatus

        if (currentRestoreRateInMegaBytesPerSecond != other.currentRestoreRateInMegaBytesPerSecond) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (snapshotSizeInMegaBytes != other.snapshotSizeInMegaBytes) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.RestoreStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types.
         */
        public var currentRestoreRateInMegaBytesPerSecond: kotlin.Double = 0.0
        /**
         * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types.
         */
        public var elapsedTimeInSeconds: kotlin.Long = 0L
        /**
         * The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types.
         */
        public var estimatedTimeToCompletionInSeconds: kotlin.Long = 0L
        /**
         * The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types.
         */
        public var progressInMegaBytes: kotlin.Long = 0L
        /**
         * The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types.
         */
        public var snapshotSizeInMegaBytes: kotlin.Long = 0L
        /**
         * The status of the restore action. Returns starting, restoring, completed, or failed.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.RestoreStatus) : this() {
            this.currentRestoreRateInMegaBytesPerSecond = x.currentRestoreRateInMegaBytesPerSecond
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.progressInMegaBytes = x.progressInMegaBytes
            this.snapshotSizeInMegaBytes = x.snapshotSizeInMegaBytes
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.RestoreStatus = RestoreStatus(this)
    }
}
