// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a resize cluster operation. For example, a scheduled action to run the `ResizeCluster` API operation.
 */
public class ResizeClusterRequest private constructor(builder: Builder) {
    /**
     * A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to `false`, the resize type is elastic.
     */
    public val classic: kotlin.Boolean? = builder.classic
    /**
     * The unique identifier for the cluster to resize.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The new cluster type for the specified cluster.
     */
    public val clusterType: kotlin.String? = builder.clusterType
    /**
     * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.
     */
    public val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * The identifier of the reserved node.
     */
    public val reservedNodeId: kotlin.String? = builder.reservedNodeId
    /**
     * The identifier of the target reserved node offering.
     */
    public val targetReservedNodeOfferingId: kotlin.String? = builder.targetReservedNodeOfferingId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResizeClusterRequest(")
        append("classic=$classic,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterType=$clusterType,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("reservedNodeId=$reservedNodeId,")
        append("targetReservedNodeOfferingId=$targetReservedNodeOfferingId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classic?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (reservedNodeId?.hashCode() ?: 0)
        result = 31 * result + (targetReservedNodeOfferingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResizeClusterRequest

        if (classic != other.classic) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterType != other.clusterType) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (reservedNodeId != other.reservedNodeId) return false
        if (targetReservedNodeOfferingId != other.targetReservedNodeOfferingId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to `false`, the resize type is elastic.
         */
        public var classic: kotlin.Boolean? = null
        /**
         * The unique identifier for the cluster to resize.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The new cluster type for the specified cluster.
         */
        public var clusterType: kotlin.String? = null
        /**
         * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.
         */
        public var numberOfNodes: kotlin.Int? = null
        /**
         * The identifier of the reserved node.
         */
        public var reservedNodeId: kotlin.String? = null
        /**
         * The identifier of the target reserved node offering.
         */
        public var targetReservedNodeOfferingId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest) : this() {
            this.classic = x.classic
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterType = x.clusterType
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.reservedNodeId = x.reservedNodeId
            this.targetReservedNodeOfferingId = x.targetReservedNodeOfferingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest = ResizeClusterRequest(this)
    }
}
