// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of logging for a cluster.
 */
public class DisableLoggingResponse private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket where the log files are stored.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The message indicating that logs failed to be delivered.
     */
    public val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The last time when logs failed to be delivered.
     */
    public val lastFailureTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastFailureTime
    /**
     * The last time that logs were delivered.
     */
    public val lastSuccessfulDeliveryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulDeliveryTime
    /**
     * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     */
    public val logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = builder.logDestinationType
    /**
     * The collection of exported log types. Possible values are `connectionlog`, `useractivitylog`, and `userlog`.
     */
    public val logExports: List<String>? = builder.logExports
    /**
     * `true` if logging is on, `false` if logging is off.
     */
    public val loggingEnabled: kotlin.Boolean = builder.loggingEnabled
    /**
     * The prefix applied to the log file names.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DisableLoggingResponse(")
        append("bucketName=$bucketName,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("lastFailureTime=$lastFailureTime,")
        append("lastSuccessfulDeliveryTime=$lastSuccessfulDeliveryTime,")
        append("logDestinationType=$logDestinationType,")
        append("logExports=$logExports,")
        append("loggingEnabled=$loggingEnabled,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (lastFailureTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulDeliveryTime?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logExports?.hashCode() ?: 0)
        result = 31 * result + (loggingEnabled.hashCode())
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DisableLoggingResponse

        if (bucketName != other.bucketName) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (lastFailureTime != other.lastFailureTime) return false
        if (lastSuccessfulDeliveryTime != other.lastSuccessfulDeliveryTime) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logExports != other.logExports) return false
        if (loggingEnabled != other.loggingEnabled) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the S3 bucket where the log files are stored.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The message indicating that logs failed to be delivered.
         */
        public var lastFailureMessage: kotlin.String? = null
        /**
         * The last time when logs failed to be delivered.
         */
        public var lastFailureTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time that logs were delivered.
         */
        public var lastSuccessfulDeliveryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
         */
        public var logDestinationType: aws.sdk.kotlin.services.redshift.model.LogDestinationType? = null
        /**
         * The collection of exported log types. Possible values are `connectionlog`, `useractivitylog`, and `userlog`.
         */
        public var logExports: List<String>? = null
        /**
         * `true` if logging is on, `false` if logging is off.
         */
        public var loggingEnabled: kotlin.Boolean = false
        /**
         * The prefix applied to the log file names.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse) : this() {
            this.bucketName = x.bucketName
            this.lastFailureMessage = x.lastFailureMessage
            this.lastFailureTime = x.lastFailureTime
            this.lastSuccessfulDeliveryTime = x.lastSuccessfulDeliveryTime
            this.logDestinationType = x.logDestinationType
            this.logExports = x.logExports
            this.loggingEnabled = x.loggingEnabled
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse = DisableLoggingResponse(this)
    }
}
