// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The result of the `DescribeSnapshotCopyGrants` action.
 */
public class DescribeSnapshotCopyGrantsRequest private constructor(builder: Builder) {
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a `DescribeSnapshotCopyGrant` request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     *
     * Constraints: You can specify either the **SnapshotCopyGrantName** parameter or the **Marker** parameter, but not both.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `100`
     *
     * Constraints: minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The name of the snapshot copy grant.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName
    /**
     * A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.
     */
    public val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.
     */
    public val tagValues: List<String>? = builder.tagValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotCopyGrantsRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSnapshotCopyGrantsRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a `DescribeSnapshotCopyGrant` request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         *
         * Constraints: You can specify either the **SnapshotCopyGrantName** parameter or the **Marker** parameter, but not both.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `100`
         *
         * Constraints: minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The name of the snapshot copy grant.
         */
        public var snapshotCopyGrantName: kotlin.String? = null
        /**
         * A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.
         */
        public var tagKeys: List<String>? = null
        /**
         * A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.
         */
        public var tagValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest = DescribeSnapshotCopyGrantsRequest(this)
    }
}
