// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The result of the `CreateSnapshotCopyGrant` action.
 */
public class CreateSnapshotCopyGrantRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.
     *
     * Constraints:
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + Alphabetic characters must be lowercase.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     * + Must be unique for all clusters within an Amazon Web Services account.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName
    /**
     * A list of tag instances.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotCopyGrantRequest(")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnapshotCopyGrantRequest

        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.
         *
         * Constraints:
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + Alphabetic characters must be lowercase.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         * + Must be unique for all clusters within an Amazon Web Services account.
         */
        public var snapshotCopyGrantName: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantRequest) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantRequest = CreateSnapshotCopyGrantRequest(this)
    }
}
