// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
public class CopyClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     *
     * The default value is -1.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     *
     * Constraints:
     * + Must be the identifier for a valid cluster.
     */
    public val sourceSnapshotClusterIdentifier: kotlin.String? = builder.sourceSnapshotClusterIdentifier
    /**
     * The identifier for the source snapshot.
     *
     * Constraints:
     * + Must be the identifier for a valid automated snapshot whose state is `available`.
     */
    public val sourceSnapshotIdentifier: kotlin.String? = builder.sourceSnapshotIdentifier
    /**
     * The identifier given to the new manual snapshot.
     *
     * Constraints:
     * + Cannot be null, empty, or blank.
     * + Must contain from 1 to 255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     * + Must be unique for the Amazon Web Services account that is making the request.
     */
    public val targetSnapshotIdentifier: kotlin.String? = builder.targetSnapshotIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyClusterSnapshotRequest(")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("sourceSnapshotClusterIdentifier=$sourceSnapshotClusterIdentifier,")
        append("sourceSnapshotIdentifier=$sourceSnapshotIdentifier,")
        append("targetSnapshotIdentifier=$targetSnapshotIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = manualSnapshotRetentionPeriod ?: 0
        result = 31 * result + (sourceSnapshotClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyClusterSnapshotRequest

        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (sourceSnapshotClusterIdentifier != other.sourceSnapshotClusterIdentifier) return false
        if (sourceSnapshotIdentifier != other.sourceSnapshotIdentifier) return false
        if (targetSnapshotIdentifier != other.targetSnapshotIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         *
         * The default value is -1.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         *
         * Constraints:
         * + Must be the identifier for a valid cluster.
         */
        public var sourceSnapshotClusterIdentifier: kotlin.String? = null
        /**
         * The identifier for the source snapshot.
         *
         * Constraints:
         * + Must be the identifier for a valid automated snapshot whose state is `available`.
         */
        public var sourceSnapshotIdentifier: kotlin.String? = null
        /**
         * The identifier given to the new manual snapshot.
         *
         * Constraints:
         * + Cannot be null, empty, or blank.
         * + Must contain from 1 to 255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         * + Must be unique for the Amazon Web Services account that is making the request.
         */
        public var targetSnapshotIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotRequest) : this() {
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.sourceSnapshotClusterIdentifier = x.sourceSnapshotClusterIdentifier
            this.sourceSnapshotIdentifier = x.sourceSnapshotIdentifier
            this.targetSnapshotIdentifier = x.targetSnapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotRequest = CopyClusterSnapshotRequest(this)
    }
}
