// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.ClusterAssociatedToSchedule
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class ModifySnapshotScheduleOperationDeserializer: HttpDeserialize<ModifySnapshotScheduleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifySnapshotScheduleResponse {
        if (!response.status.isSuccess()) {
            throwModifySnapshotScheduleError(context, response)
        }
        val builder = ModifySnapshotScheduleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifySnapshotScheduleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifySnapshotScheduleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidSchedule" -> InvalidScheduleFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotScheduleUpdateInProgress" -> SnapshotScheduleUpdateInProgressFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifySnapshotScheduleOperationBody(builder: ModifySnapshotScheduleResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifySnapshotScheduleResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifySnapshotScheduleResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifySnapshotSchedule response")
    }
    // end unwrap response wrapper

    val ASSOCIATEDCLUSTERCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("AssociatedClusterCount"))
    val ASSOCIATEDCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AssociatedClusters"), XmlCollectionName("ClusterAssociatedToSchedule"))
    val NEXTINVOCATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("NextInvocations"), XmlCollectionName("SnapshotTime"))
    val SCHEDULEDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ScheduleDefinitions"), XmlCollectionName("ScheduleDefinition"))
    val SCHEDULEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ScheduleDescription"))
    val SCHEDULEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ScheduleIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"), XmlCollectionName("Tag"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifySnapshotScheduleResult"))
        field(ASSOCIATEDCLUSTERCOUNT_DESCRIPTOR)
        field(ASSOCIATEDCLUSTERS_DESCRIPTOR)
        field(NEXTINVOCATIONS_DESCRIPTOR)
        field(SCHEDULEDEFINITIONS_DESCRIPTOR)
        field(SCHEDULEDESCRIPTION_DESCRIPTOR)
        field(SCHEDULEIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATEDCLUSTERCOUNT_DESCRIPTOR.index -> builder.associatedClusterCount = deserializeInt()
                ASSOCIATEDCLUSTERS_DESCRIPTOR.index -> builder.associatedClusters =
                    deserializer.deserializeList(ASSOCIATEDCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ClusterAssociatedToSchedule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeClusterAssociatedToScheduleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTINVOCATIONS_DESCRIPTOR.index -> builder.nextInvocations =
                    deserializer.deserializeList(NEXTINVOCATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Instant>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Instant.fromIso8601(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEDULEDEFINITIONS_DESCRIPTOR.index -> builder.scheduleDefinitions =
                    deserializer.deserializeList(SCHEDULEDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEDULEDESCRIPTION_DESCRIPTOR.index -> builder.scheduleDescription = deserializeString()
                SCHEDULEIDENTIFIER_DESCRIPTOR.index -> builder.scheduleIdentifier = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
