// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.redshift.model.ScheduledActionFilter
import aws.sdk.kotlin.services.redshift.model.ScheduledActionTypeValues
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeScheduledActionsOperationSerializer: HttpSerialize<DescribeScheduledActionsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DescribeScheduledActionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDescribeScheduledActionsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeDescribeScheduledActionsOperationBody(context: ExecutionContext, input: DescribeScheduledActionsRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Active"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("EndTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Filters"), FormUrlCollectionName("ScheduledActionFilter"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Marker"))
    val MAXRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxRecords"))
    val SCHEDULEDACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ScheduledActionName"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("StartTime"))
    val TARGETACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("TargetActionType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("DescribeScheduledActionsMessage"))
        trait(QueryLiteral("Action", "DescribeScheduledActions"))
        trait(QueryLiteral("Version", "2012-12-01"))
        field(ACTIVE_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(MAXRECORDS_DESCRIPTOR)
        field(SCHEDULEDACTIONNAME_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TARGETACTIONTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.active?.let { field(ACTIVE_DESCRIPTOR, it) }
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeScheduledActionFilterDocument))
                }
            }
        }
        input.marker?.let { field(MARKER_DESCRIPTOR, it) }
        input.maxRecords?.let { field(MAXRECORDS_DESCRIPTOR, it) }
        input.scheduledActionName?.let { field(SCHEDULEDACTIONNAME_DESCRIPTOR, it) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.targetActionType?.let { field(TARGETACTIONTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
