// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ReservedNodeExchangeStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeReservedNodeExchangeStatusOperationDeserializer: HttpDeserialize<DescribeReservedNodeExchangeStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeReservedNodeExchangeStatusResponse {
        if (!response.status.isSuccess()) {
            throwDescribeReservedNodeExchangeStatusError(context, response)
        }
        val builder = DescribeReservedNodeExchangeStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReservedNodeExchangeStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeReservedNodeExchangeStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedNodeExchangeNotFond" -> ReservedNodeExchangeNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReservedNodeExchangeStatusOperationBody(builder: DescribeReservedNodeExchangeStatusResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeReservedNodeExchangeStatusResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeReservedNodeExchangeStatusResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeReservedNodeExchangeStatus response")
    }
    // end unwrap response wrapper

    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val RESERVEDNODEEXCHANGESTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ReservedNodeExchangeStatusDetails"), XmlCollectionName("ReservedNodeExchangeStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DescribeReservedNodeExchangeStatusResult"))
        field(MARKER_DESCRIPTOR)
        field(RESERVEDNODEEXCHANGESTATUSDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                RESERVEDNODEEXCHANGESTATUSDETAILS_DESCRIPTOR.index -> builder.reservedNodeExchangeStatusDetails =
                    deserializer.deserializeList(RESERVEDNODEEXCHANGESTATUSDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedNodeExchangeStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedNodeExchangeStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
