// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.NodeConfigurationOption
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeNodeConfigurationOptionsOperationDeserializer: HttpDeserialize<DescribeNodeConfigurationOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeNodeConfigurationOptionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeNodeConfigurationOptionsError(context, response)
        }
        val builder = DescribeNodeConfigurationOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNodeConfigurationOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeNodeConfigurationOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessToSnapshotDenied" -> AccessToSnapshotDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterSnapshotState" -> InvalidClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNodeConfigurationOptionsOperationBody(builder: DescribeNodeConfigurationOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeNodeConfigurationOptionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeNodeConfigurationOptionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeNodeConfigurationOptions response")
    }
    // end unwrap response wrapper

    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val NODECONFIGURATIONOPTIONLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("NodeConfigurationOptionList"), XmlCollectionName("NodeConfigurationOption"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DescribeNodeConfigurationOptionsResult"))
        field(MARKER_DESCRIPTOR)
        field(NODECONFIGURATIONOPTIONLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                NODECONFIGURATIONOPTIONLIST_DESCRIPTOR.index -> builder.nodeConfigurationOptionList =
                    deserializer.deserializeList(NODECONFIGURATIONOPTIONLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<NodeConfigurationOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNodeConfigurationOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
