// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotCopyGrantResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteSnapshotCopyGrantOperationDeserializer: HttpDeserialize<DeleteSnapshotCopyGrantResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteSnapshotCopyGrantResponse {
        if (!response.status.isSuccess()) {
            throwDeleteSnapshotCopyGrantError(context, response)
        }
        val builder = DeleteSnapshotCopyGrantResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteSnapshotCopyGrantError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidSnapshotCopyGrantStateFault" -> InvalidSnapshotCopyGrantStateFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotCopyGrantNotFoundFault" -> SnapshotCopyGrantNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
