// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DataShareAssociation
import aws.sdk.kotlin.services.redshift.model.DeauthorizeDataShareResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DeauthorizeDataShareOperationDeserializer: HttpDeserialize<DeauthorizeDataShareResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeauthorizeDataShareResponse {
        if (!response.status.isSuccess()) {
            throwDeauthorizeDataShareError(context, response)
        }
        val builder = DeauthorizeDataShareResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeauthorizeDataShareOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeauthorizeDataShareError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDataShareFault" -> InvalidDataShareFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeauthorizeDataShareOperationBody(builder: DeauthorizeDataShareResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DeauthorizeDataShareResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DeauthorizeDataShareResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DeauthorizeDataShare response")
    }
    // end unwrap response wrapper

    val ALLOWPUBLICLYACCESSIBLECONSUMERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AllowPubliclyAccessibleConsumers"))
    val DATASHAREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DataShareArn"))
    val DATASHAREASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("DataShareAssociations"))
    val MANAGEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ManagedBy"))
    val PRODUCERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ProducerArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DeauthorizeDataShareResult"))
        field(ALLOWPUBLICLYACCESSIBLECONSUMERS_DESCRIPTOR)
        field(DATASHAREARN_DESCRIPTOR)
        field(DATASHAREASSOCIATIONS_DESCRIPTOR)
        field(MANAGEDBY_DESCRIPTOR)
        field(PRODUCERARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWPUBLICLYACCESSIBLECONSUMERS_DESCRIPTOR.index -> builder.allowPubliclyAccessibleConsumers = deserializeBoolean()
                DATASHAREARN_DESCRIPTOR.index -> builder.dataShareArn = deserializeString()
                DATASHAREASSOCIATIONS_DESCRIPTOR.index -> builder.dataShareAssociations =
                    deserializer.deserializeList(DATASHAREASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataShareAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataShareAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MANAGEDBY_DESCRIPTOR.index -> builder.managedBy = deserializeString()
                PRODUCERARN_DESCRIPTOR.index -> builder.producerArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
