// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AuthorizeEndpointAccessOperationSerializer: HttpSerialize<AuthorizeEndpointAccessRequest> {
    override suspend fun serialize(context: ExecutionContext, input: AuthorizeEndpointAccessRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeAuthorizeEndpointAccessOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeAuthorizeEndpointAccessOperationBody(context: ExecutionContext, input: AuthorizeEndpointAccessRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Account"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClusterIdentifier"))
    val VPCIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcIds"), FormUrlCollectionName("VpcIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("AuthorizeEndpointAccessMessage"))
        trait(QueryLiteral("Action", "AuthorizeEndpointAccess"))
        trait(QueryLiteral("Version", "2012-12-01"))
        field(ACCOUNT_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(VPCIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.account?.let { field(ACCOUNT_DESCRIPTOR, it) }
        input.clusterIdentifier?.let { field(CLUSTERIDENTIFIER_DESCRIPTOR, it) }
        if (input.vpcIds != null) {
            listField(VPCIDS_DESCRIPTOR) {
                for (el0 in input.vpcIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
