// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a parameter group.
 */
public class ClusterParameterStatus private constructor(builder: Builder) {
    /**
     * The error that prevented the parameter from being applied to the database.
     */
    public val parameterApplyErrorDescription: kotlin.String? = builder.parameterApplyErrorDescription
    /**
     * The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.
     *
     * The following are possible statuses and descriptions.
     * + `in-sync`: The parameter value is in sync with the database.
     * + `pending-reboot`: The parameter value will be applied after the cluster reboots.
     * + `applying`: The parameter value is being applied to the database.
     * + `invalid-parameter`: Cannot apply the parameter value because it has an invalid value or syntax.
     * + `apply-deferred`: The parameter contains static property changes. The changes are deferred until the cluster reboots.
     * + `apply-error`: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.
     * + `unknown-error`: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.
     */
    public val parameterApplyStatus: kotlin.String? = builder.parameterApplyStatus
    /**
     * The name of the parameter.
     */
    public val parameterName: kotlin.String? = builder.parameterName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ClusterParameterStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterParameterStatus(")
        append("parameterApplyErrorDescription=$parameterApplyErrorDescription,")
        append("parameterApplyStatus=$parameterApplyStatus,")
        append("parameterName=$parameterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameterApplyErrorDescription?.hashCode() ?: 0
        result = 31 * result + (parameterApplyStatus?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterParameterStatus

        if (parameterApplyErrorDescription != other.parameterApplyErrorDescription) return false
        if (parameterApplyStatus != other.parameterApplyStatus) return false
        if (parameterName != other.parameterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ClusterParameterStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The error that prevented the parameter from being applied to the database.
         */
        public var parameterApplyErrorDescription: kotlin.String? = null
        /**
         * The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.
         *
         * The following are possible statuses and descriptions.
         * + `in-sync`: The parameter value is in sync with the database.
         * + `pending-reboot`: The parameter value will be applied after the cluster reboots.
         * + `applying`: The parameter value is being applied to the database.
         * + `invalid-parameter`: Cannot apply the parameter value because it has an invalid value or syntax.
         * + `apply-deferred`: The parameter contains static property changes. The changes are deferred until the cluster reboots.
         * + `apply-error`: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.
         * + `unknown-error`: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.
         */
        public var parameterApplyStatus: kotlin.String? = null
        /**
         * The name of the parameter.
         */
        public var parameterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ClusterParameterStatus) : this() {
            this.parameterApplyErrorDescription = x.parameterApplyErrorDescription
            this.parameterApplyStatus = x.parameterApplyStatus
            this.parameterName = x.parameterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ClusterParameterStatus = ClusterParameterStatus(this)
    }
}
