// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.redshift.model.*
import aws.sdk.kotlin.services.redshift.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Redshift"
public const val ServiceApiVersion: String = "2012-12-01"
public const val SdkVersion: String = "0.17.1-beta"

internal class DefaultRedshiftClient(override val config: RedshiftClient.Config) : RedshiftClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.
     */
    override suspend fun acceptReservedNodeExchange(input: AcceptReservedNodeExchangeRequest): AcceptReservedNodeExchangeResponse {
        val op = SdkHttpOperation.build<AcceptReservedNodeExchangeRequest, AcceptReservedNodeExchangeResponse> {
            serializer = AcceptReservedNodeExchangeOperationSerializer()
            deserializer = AcceptReservedNodeExchangeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptReservedNodeExchange"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.
     */
    override suspend fun addPartner(input: AddPartnerRequest): AddPartnerResponse {
        val op = SdkHttpOperation.build<AddPartnerRequest, AddPartnerResponse> {
            serializer = AddPartnerOperationSerializer()
            deserializer = AddPartnerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddPartner"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     */
    override suspend fun associateDataShareConsumer(input: AssociateDataShareConsumerRequest): AssociateDataShareConsumerResponse {
        val op = SdkHttpOperation.build<AssociateDataShareConsumerRequest, AssociateDataShareConsumerResponse> {
            serializer = AssociateDataShareConsumerOperationSerializer()
            deserializer = AssociateDataShareConsumerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDataShareConsumer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.
     *
     * If you authorize access to an Amazon EC2 security group, specify *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.
     *
     * If you authorize access to a CIDR/IP address range, specify *CIDRIP*. For an overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to [Working with Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun authorizeClusterSecurityGroupIngress(input: AuthorizeClusterSecurityGroupIngressRequest): AuthorizeClusterSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<AuthorizeClusterSecurityGroupIngressRequest, AuthorizeClusterSecurityGroupIngressResponse> {
            serializer = AuthorizeClusterSecurityGroupIngressOperationSerializer()
            deserializer = AuthorizeClusterSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeClusterSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.
     */
    override suspend fun authorizeDataShare(input: AuthorizeDataShareRequest): AuthorizeDataShareResponse {
        val op = SdkHttpOperation.build<AuthorizeDataShareRequest, AuthorizeDataShareResponse> {
            serializer = AuthorizeDataShareOperationSerializer()
            deserializer = AuthorizeDataShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeDataShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Grants access to a cluster.
     */
    override suspend fun authorizeEndpointAccess(input: AuthorizeEndpointAccessRequest): AuthorizeEndpointAccessResponse {
        val op = SdkHttpOperation.build<AuthorizeEndpointAccessRequest, AuthorizeEndpointAccessResponse> {
            serializer = AuthorizeEndpointAccessOperationSerializer()
            deserializer = AuthorizeEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun authorizeSnapshotAccess(input: AuthorizeSnapshotAccessRequest): AuthorizeSnapshotAccessResponse {
        val op = SdkHttpOperation.build<AuthorizeSnapshotAccessRequest, AuthorizeSnapshotAccessResponse> {
            serializer = AuthorizeSnapshotAccessOperationSerializer()
            deserializer = AuthorizeSnapshotAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeSnapshotAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a set of cluster snapshots.
     */
    override suspend fun batchDeleteClusterSnapshots(input: BatchDeleteClusterSnapshotsRequest): BatchDeleteClusterSnapshotsResponse {
        val op = SdkHttpOperation.build<BatchDeleteClusterSnapshotsRequest, BatchDeleteClusterSnapshotsResponse> {
            serializer = BatchDeleteClusterSnapshotsOperationSerializer()
            deserializer = BatchDeleteClusterSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteClusterSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for a set of cluster snapshots.
     */
    override suspend fun batchModifyClusterSnapshots(input: BatchModifyClusterSnapshotsRequest): BatchModifyClusterSnapshotsResponse {
        val op = SdkHttpOperation.build<BatchModifyClusterSnapshotsRequest, BatchModifyClusterSnapshotsResponse> {
            serializer = BatchModifyClusterSnapshotsOperationSerializer()
            deserializer = BatchModifyClusterSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchModifyClusterSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a resize operation for a cluster.
     */
    override suspend fun cancelResize(input: CancelResizeRequest): CancelResizeResponse {
        val op = SdkHttpOperation.build<CancelResizeRequest, CancelResizeResponse> {
            serializer = CancelResizeOperationSerializer()
            deserializer = CancelResizeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelResize"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.
     *
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun copyClusterSnapshot(input: CopyClusterSnapshotRequest): CopyClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CopyClusterSnapshotRequest, CopyClusterSnapshotResponse> {
            serializer = CopyClusterSnapshotOperationSerializer()
            deserializer = CopyClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an authentication profile with the specified parameters.
     */
    override suspend fun createAuthenticationProfile(input: CreateAuthenticationProfileRequest): CreateAuthenticationProfileResponse {
        val op = SdkHttpOperation.build<CreateAuthenticationProfileRequest, CreateAuthenticationProfileResponse> {
            serializer = CreateAuthenticationProfileOperationSerializer()
            deserializer = CreateAuthenticationProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAuthenticationProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cluster with the specified parameters.
     *
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse {
        val op = SdkHttpOperation.build<CreateClusterRequest, CreateClusterResponse> {
            serializer = CreateClusterOperationSerializer()
            deserializer = CreateClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Redshift parameter group.
     *
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.
     *
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createClusterParameterGroup(input: CreateClusterParameterGroupRequest): CreateClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateClusterParameterGroupRequest, CreateClusterParameterGroupResponse> {
            serializer = CreateClusterParameterGroupOperationSerializer()
            deserializer = CreateClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClusterParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createClusterSecurityGroup(input: CreateClusterSecurityGroupRequest): CreateClusterSecurityGroupResponse {
        val op = SdkHttpOperation.build<CreateClusterSecurityGroupRequest, CreateClusterSecurityGroupResponse> {
            serializer = CreateClusterSecurityGroupOperationSerializer()
            deserializer = CreateClusterSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClusterSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a manual snapshot of the specified cluster. The cluster must be in the `available` state.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createClusterSnapshot(input: CreateClusterSnapshotRequest): CreateClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CreateClusterSnapshotRequest, CreateClusterSnapshotResponse> {
            serializer = CreateClusterSnapshotOperationSerializer()
            deserializer = CreateClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     *
     *  For information about subnet groups, go to [Amazon Redshift Cluster Subnet Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createClusterSubnetGroup(input: CreateClusterSubnetGroupRequest): CreateClusterSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateClusterSubnetGroupRequest, CreateClusterSubnetGroupResponse> {
            serializer = CreateClusterSubnetGroupOperationSerializer()
            deserializer = CreateClusterSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClusterSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Redshift-managed VPC endpoint.
     */
    override suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse {
        val op = SdkHttpOperation.build<CreateEndpointAccessRequest, CreateEndpointAccessResponse> {
            serializer = CreateEndpointAccessOperationSerializer()
            deserializer = CreateEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.
     *
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.
     */
    override suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse> {
            serializer = CreateEventSubscriptionOperationSerializer()
            deserializer = CreateEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
     *
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createHsmClientCertificate(input: CreateHsmClientCertificateRequest): CreateHsmClientCertificateResponse {
        val op = SdkHttpOperation.build<CreateHsmClientCertificateRequest, CreateHsmClientCertificateResponse> {
            serializer = CreateHsmClientCertificateOperationSerializer()
            deserializer = CreateHsmClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHsmClientCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     *
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in the Amazon Redshift Cluster Management Guide.
     */
    override suspend fun createHsmConfiguration(input: CreateHsmConfigurationRequest): CreateHsmConfigurationResponse {
        val op = SdkHttpOperation.build<CreateHsmConfigurationRequest, CreateHsmConfigurationResponse> {
            serializer = CreateHsmConfigurationOperationSerializer()
            deserializer = CreateHsmConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHsmConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `ResizeCluster` API operation.
     */
    override suspend fun createScheduledAction(input: CreateScheduledActionRequest): CreateScheduledActionResponse {
        val op = SdkHttpOperation.build<CreateScheduledActionRequest, CreateScheduledActionResponse> {
            serializer = CreateScheduledActionOperationSerializer()
            deserializer = CreateScheduledActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateScheduledAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun createSnapshotCopyGrant(input: CreateSnapshotCopyGrantRequest): CreateSnapshotCopyGrantResponse {
        val op = SdkHttpOperation.build<CreateSnapshotCopyGrantRequest, CreateSnapshotCopyGrantResponse> {
            serializer = CreateSnapshotCopyGrantOperationSerializer()
            deserializer = CreateSnapshotCopyGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshotCopyGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.
     */
    override suspend fun createSnapshotSchedule(input: CreateSnapshotScheduleRequest): CreateSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<CreateSnapshotScheduleRequest, CreateSnapshotScheduleResponse> {
            serializer = CreateSnapshotScheduleOperationSerializer()
            deserializer = CreateSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshotSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to a cluster.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.
     *
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new value.
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.
     */
    override suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse {
        val op = SdkHttpOperation.build<CreateUsageLimitRequest, CreateUsageLimitResponse> {
            serializer = CreateUsageLimitOperationSerializer()
            deserializer = CreateUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * From a datashare producer account, removes authorization from the specified datashare.
     */
    override suspend fun deauthorizeDataShare(input: DeauthorizeDataShareRequest): DeauthorizeDataShareResponse {
        val op = SdkHttpOperation.build<DeauthorizeDataShareRequest, DeauthorizeDataShareResponse> {
            serializer = DeauthorizeDataShareOperationSerializer()
            deserializer = DeauthorizeDataShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeauthorizeDataShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an authentication profile.
     */
    override suspend fun deleteAuthenticationProfile(input: DeleteAuthenticationProfileRequest): DeleteAuthenticationProfileResponse {
        val op = SdkHttpOperation.build<DeleteAuthenticationProfileRequest, DeleteAuthenticationProfileResponse> {
            serializer = DeleteAuthenticationProfileOperationSerializer()
            deserializer = DeleteAuthenticationProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAuthenticationProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you want to shut down the cluster and retain it for future use, set *SkipFinalClusterSnapshot* to `false` and specify a name for *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster.
     *
     *  For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse {
        val op = SdkHttpOperation.build<DeleteClusterRequest, DeleteClusterResponse> {
            serializer = DeleteClusterOperationSerializer()
            deserializer = DeleteClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified Amazon Redshift parameter group.
     *
     * You cannot delete a parameter group if it is associated with a cluster.
     */
    override suspend fun deleteClusterParameterGroup(input: DeleteClusterParameterGroupRequest): DeleteClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteClusterParameterGroupRequest, DeleteClusterParameterGroupResponse> {
            serializer = DeleteClusterParameterGroupOperationSerializer()
            deserializer = DeleteClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClusterParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Redshift security group.
     *
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun deleteClusterSecurityGroup(input: DeleteClusterSecurityGroupRequest): DeleteClusterSecurityGroupResponse {
        val op = SdkHttpOperation.build<DeleteClusterSecurityGroupRequest, DeleteClusterSecurityGroupResponse> {
            serializer = DeleteClusterSecurityGroupOperationSerializer()
            deserializer = DeleteClusterSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClusterSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified manual snapshot. The snapshot must be in the `available` state, with no other users authorized to access the snapshot.
     *
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.
     */
    override suspend fun deleteClusterSnapshot(input: DeleteClusterSnapshotRequest): DeleteClusterSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteClusterSnapshotRequest, DeleteClusterSnapshotResponse> {
            serializer = DeleteClusterSnapshotOperationSerializer()
            deserializer = DeleteClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified cluster subnet group.
     */
    override suspend fun deleteClusterSubnetGroup(input: DeleteClusterSubnetGroupRequest): DeleteClusterSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteClusterSubnetGroupRequest, DeleteClusterSubnetGroupResponse> {
            serializer = DeleteClusterSubnetGroupOperationSerializer()
            deserializer = DeleteClusterSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClusterSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Redshift-managed VPC endpoint.
     */
    override suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse {
        val op = SdkHttpOperation.build<DeleteEndpointAccessRequest, DeleteEndpointAccessResponse> {
            serializer = DeleteEndpointAccessOperationSerializer()
            deserializer = DeleteEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Redshift event notification subscription.
     */
    override suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse> {
            serializer = DeleteEventSubscriptionOperationSerializer()
            deserializer = DeleteEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified HSM client certificate.
     */
    override suspend fun deleteHsmClientCertificate(input: DeleteHsmClientCertificateRequest): DeleteHsmClientCertificateResponse {
        val op = SdkHttpOperation.build<DeleteHsmClientCertificateRequest, DeleteHsmClientCertificateResponse> {
            serializer = DeleteHsmClientCertificateOperationSerializer()
            deserializer = DeleteHsmClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteHsmClientCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Redshift HSM configuration.
     */
    override suspend fun deleteHsmConfiguration(input: DeleteHsmConfigurationRequest): DeleteHsmConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteHsmConfigurationRequest, DeleteHsmConfigurationResponse> {
            serializer = DeleteHsmConfigurationOperationSerializer()
            deserializer = DeleteHsmConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteHsmConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.
     */
    override suspend fun deletePartner(input: DeletePartnerRequest): DeletePartnerResponse {
        val op = SdkHttpOperation.build<DeletePartnerRequest, DeletePartnerResponse> {
            serializer = DeletePartnerOperationSerializer()
            deserializer = DeletePartnerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePartner"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a scheduled action.
     */
    override suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse {
        val op = SdkHttpOperation.build<DeleteScheduledActionRequest, DeleteScheduledActionResponse> {
            serializer = DeleteScheduledActionOperationSerializer()
            deserializer = DeleteScheduledActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteScheduledAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified snapshot copy grant.
     */
    override suspend fun deleteSnapshotCopyGrant(input: DeleteSnapshotCopyGrantRequest): DeleteSnapshotCopyGrantResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotCopyGrantRequest, DeleteSnapshotCopyGrantResponse> {
            serializer = DeleteSnapshotCopyGrantOperationSerializer()
            deserializer = DeleteSnapshotCopyGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshotCopyGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a snapshot schedule.
     */
    override suspend fun deleteSnapshotSchedule(input: DeleteSnapshotScheduleRequest): DeleteSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotScheduleRequest, DeleteSnapshotScheduleResponse> {
            serializer = DeleteSnapshotScheduleOperationSerializer()
            deserializer = DeleteSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshotSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage limit from a cluster.
     */
    override suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse {
        val op = SdkHttpOperation.build<DeleteUsageLimitRequest, DeleteUsageLimitResponse> {
            serializer = DeleteUsageLimitOperationSerializer()
            deserializer = DeleteUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of attributes attached to an account
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializer = DescribeAccountAttributesOperationSerializer()
            deserializer = DescribeAccountAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an authentication profile.
     */
    override suspend fun describeAuthenticationProfiles(input: DescribeAuthenticationProfilesRequest): DescribeAuthenticationProfilesResponse {
        val op = SdkHttpOperation.build<DescribeAuthenticationProfilesRequest, DescribeAuthenticationProfilesResponse> {
            serializer = DescribeAuthenticationProfilesOperationSerializer()
            deserializer = DescribeAuthenticationProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuthenticationProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `ClusterDbRevision` objects.
     */
    override suspend fun describeClusterDbRevisions(input: DescribeClusterDbRevisionsRequest): DescribeClusterDbRevisionsResponse {
        val op = SdkHttpOperation.build<DescribeClusterDbRevisionsRequest, DescribeClusterDbRevisionsResponse> {
            serializer = DescribeClusterDbRevisionsOperationSerializer()
            deserializer = DescribeClusterDbRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterDbRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all parameter groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeClusterParameterGroups(input: DescribeClusterParameterGroupsRequest): DescribeClusterParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResponse> {
            serializer = DescribeClusterParameterGroupsOperationSerializer()
            deserializer = DescribeClusterParameterGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterParameterGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.
     *
     * You can specify *source* filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from ModifyClusterParameterGroup, you can specify *source* equal to *user*.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeClusterParameters(input: DescribeClusterParametersRequest): DescribeClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeClusterParametersRequest, DescribeClusterParametersResponse> {
            serializer = DescribeClusterParametersOperationSerializer()
            deserializer = DescribeClusterParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all security groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeClusterSecurityGroups(input: DescribeClusterSecurityGroupsRequest): DescribeClusterSecurityGroupsResponse {
        val op = SdkHttpOperation.build<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResponse> {
            serializer = DescribeClusterSecurityGroupsOperationSerializer()
            deserializer = DescribeClusterSecurityGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterSecurityGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.
     *
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeClusterSnapshots(input: DescribeClusterSnapshotsRequest): DescribeClusterSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResponse> {
            serializer = DescribeClusterSnapshotsOperationSerializer()
            deserializer = DescribeClusterSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subnet groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeClusterSubnetGroups(input: DescribeClusterSubnetGroupsRequest): DescribeClusterSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResponse> {
            serializer = DescribeClusterSubnetGroupsOperationSerializer()
            deserializer = DescribeClusterSubnetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterSubnetGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the available maintenance tracks.
     */
    override suspend fun describeClusterTracks(input: DescribeClusterTracksRequest): DescribeClusterTracksResponse {
        val op = SdkHttpOperation.build<DescribeClusterTracksRequest, DescribeClusterTracksResponse> {
            serializer = DescribeClusterTracksOperationSerializer()
            deserializer = DescribeClusterTracksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterTracks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeClusterVersions(input: DescribeClusterVersionsRequest): DescribeClusterVersionsResponse {
        val op = SdkHttpOperation.build<DescribeClusterVersionsRequest, DescribeClusterVersionsResponse> {
            serializer = DescribeClusterVersionsOperationSerializer()
            deserializer = DescribeClusterVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all clusters that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeClusters(input: DescribeClustersRequest): DescribeClustersResponse {
        val op = SdkHttpOperation.build<DescribeClustersRequest, DescribeClustersResponse> {
            serializer = DescribeClustersOperationSerializer()
            deserializer = DescribeClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Shows the status of any inbound or outbound datashares available in the specified account.
     */
    override suspend fun describeDataShares(input: DescribeDataSharesRequest): DescribeDataSharesResponse {
        val op = SdkHttpOperation.build<DescribeDataSharesRequest, DescribeDataSharesResponse> {
            serializer = DescribeDataSharesOperationSerializer()
            deserializer = DescribeDataSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataShares"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     */
    override suspend fun describeDataSharesForConsumer(input: DescribeDataSharesForConsumerRequest): DescribeDataSharesForConsumerResponse {
        val op = SdkHttpOperation.build<DescribeDataSharesForConsumerRequest, DescribeDataSharesForConsumerResponse> {
            serializer = DescribeDataSharesForConsumerOperationSerializer()
            deserializer = DescribeDataSharesForConsumerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSharesForConsumer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     */
    override suspend fun describeDataSharesForProducer(input: DescribeDataSharesForProducerRequest): DescribeDataSharesForProducerResponse {
        val op = SdkHttpOperation.build<DescribeDataSharesForProducerRequest, DescribeDataSharesForProducerResponse> {
            serializer = DescribeDataSharesForProducerOperationSerializer()
            deserializer = DescribeDataSharesForProducerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSharesForProducer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of parameter settings for the specified parameter group family.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeDefaultClusterParameters(input: DescribeDefaultClusterParametersRequest): DescribeDefaultClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeDefaultClusterParametersRequest, DescribeDefaultClusterParametersResponse> {
            serializer = DescribeDefaultClusterParametersOperationSerializer()
            deserializer = DescribeDefaultClusterParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDefaultClusterParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a Redshift-managed VPC endpoint.
     */
    override suspend fun describeEndpointAccess(input: DescribeEndpointAccessRequest): DescribeEndpointAccessResponse {
        val op = SdkHttpOperation.build<DescribeEndpointAccessRequest, DescribeEndpointAccessResponse> {
            serializer = DescribeEndpointAccessOperationSerializer()
            deserializer = DescribeEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an endpoint authorization.
     */
    override suspend fun describeEndpointAuthorization(input: DescribeEndpointAuthorizationRequest): DescribeEndpointAuthorizationResponse {
        val op = SdkHttpOperation.build<DescribeEndpointAuthorizationRequest, DescribeEndpointAuthorizationResponse> {
            serializer = DescribeEndpointAuthorizationOperationSerializer()
            deserializer = DescribeEndpointAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to [Amazon Redshift Event Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
     */
    override suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse {
        val op = SdkHttpOperation.build<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse> {
            serializer = DescribeEventCategoriesOperationSerializer()
            deserializer = DescribeEventCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventCategories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subscriptions that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse> {
            serializer = DescribeEventSubscriptionsOperationSerializer()
            deserializer = DescribeEventSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventSubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM client certificates that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeHsmClientCertificates(input: DescribeHsmClientCertificatesRequest): DescribeHsmClientCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeHsmClientCertificatesRequest, DescribeHsmClientCertificatesResponse> {
            serializer = DescribeHsmClientCertificatesOperationSerializer()
            deserializer = DescribeHsmClientCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHsmClientCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM connections that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeHsmConfigurations(input: DescribeHsmConfigurationsRequest): DescribeHsmConfigurationsResponse {
        val op = SdkHttpOperation.build<DescribeHsmConfigurationsRequest, DescribeHsmConfigurationsResponse> {
            serializer = DescribeHsmConfigurationsOperationSerializer()
            deserializer = DescribeHsmConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHsmConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.
     */
    override suspend fun describeLoggingStatus(input: DescribeLoggingStatusRequest): DescribeLoggingStatusResponse {
        val op = SdkHttpOperation.build<DescribeLoggingStatusRequest, DescribeLoggingStatusResponse> {
            serializer = DescribeLoggingStatusOperationSerializer()
            deserializer = DescribeLoggingStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoggingStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.
     */
    override suspend fun describeNodeConfigurationOptions(input: DescribeNodeConfigurationOptionsRequest): DescribeNodeConfigurationOptionsResponse {
        val op = SdkHttpOperation.build<DescribeNodeConfigurationOptionsRequest, DescribeNodeConfigurationOptionsResponse> {
            serializer = DescribeNodeConfigurationOptionsOperationSerializer()
            deserializer = DescribeNodeConfigurationOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNodeConfigurationOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeOrderableClusterOptions(input: DescribeOrderableClusterOptionsRequest): DescribeOrderableClusterOptionsResponse {
        val op = SdkHttpOperation.build<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResponse> {
            serializer = DescribeOrderableClusterOptionsOperationSerializer()
            deserializer = DescribeOrderableClusterOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrderableClusterOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the partner integrations defined for a cluster.
     */
    override suspend fun describePartners(input: DescribePartnersRequest): DescribePartnersResponse {
        val op = SdkHttpOperation.build<DescribePartnersRequest, DescribePartnersResponse> {
            serializer = DescribePartnersOperationSerializer()
            deserializer = DescribePartnersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePartners"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.
     */
    override suspend fun describeReservedNodeExchangeStatus(input: DescribeReservedNodeExchangeStatusRequest): DescribeReservedNodeExchangeStatusResponse {
        val op = SdkHttpOperation.build<DescribeReservedNodeExchangeStatusRequest, DescribeReservedNodeExchangeStatusResponse> {
            serializer = DescribeReservedNodeExchangeStatusOperationSerializer()
            deserializer = DescribeReservedNodeExchangeStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedNodeExchangeStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeReservedNodeOfferings(input: DescribeReservedNodeOfferingsRequest): DescribeReservedNodeOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResponse> {
            serializer = DescribeReservedNodeOfferingsOperationSerializer()
            deserializer = DescribeReservedNodeOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedNodeOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the descriptions of the reserved nodes.
     */
    override suspend fun describeReservedNodes(input: DescribeReservedNodesRequest): DescribeReservedNodesResponse {
        val op = SdkHttpOperation.build<DescribeReservedNodesRequest, DescribeReservedNodesResponse> {
            serializer = DescribeReservedNodesOperationSerializer()
            deserializer = DescribeReservedNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a `HTTP 404` error is returned. If a resize operation was initiated and completed, the status of the resize remains as `SUCCEEDED` until the next resize.
     *
     * A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.
     */
    override suspend fun describeResize(input: DescribeResizeRequest): DescribeResizeResponse {
        val op = SdkHttpOperation.build<DescribeResizeRequest, DescribeResizeResponse> {
            serializer = DescribeResizeOperationSerializer()
            deserializer = DescribeResizeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResize"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes properties of scheduled actions.
     */
    override suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest): DescribeScheduledActionsResponse {
        val op = SdkHttpOperation.build<DescribeScheduledActionsRequest, DescribeScheduledActionsResponse> {
            serializer = DescribeScheduledActionsOperationSerializer()
            deserializer = DescribeScheduledActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScheduledActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun describeSnapshotCopyGrants(input: DescribeSnapshotCopyGrantsRequest): DescribeSnapshotCopyGrantsResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotCopyGrantsRequest, DescribeSnapshotCopyGrantsResponse> {
            serializer = DescribeSnapshotCopyGrantsOperationSerializer()
            deserializer = DescribeSnapshotCopyGrantsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshotCopyGrants"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of snapshot schedules.
     */
    override suspend fun describeSnapshotSchedules(input: DescribeSnapshotSchedulesRequest): DescribeSnapshotSchedulesResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotSchedulesRequest, DescribeSnapshotSchedulesResponse> {
            serializer = DescribeSnapshotSchedulesOperationSerializer()
            deserializer = DescribeSnapshotSchedulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshotSchedules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns account level backups storage size and provisional storage.
     */
    override suspend fun describeStorage(input: DescribeStorageRequest): DescribeStorageResponse {
        val op = SdkHttpOperation.build<DescribeStorageRequest, DescribeStorageResponse> {
            serializer = DescribeStorageOperationSerializer()
            deserializer = DescribeStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStorage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the `TableRestoreRequestId` parameter, then `DescribeTableRestoreStatus` returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise `DescribeTableRestoreStatus` returns the status of the table specified by `TableRestoreRequestId`.
     */
    override suspend fun describeTableRestoreStatus(input: DescribeTableRestoreStatusRequest): DescribeTableRestoreStatusResponse {
        val op = SdkHttpOperation.build<DescribeTableRestoreStatusRequest, DescribeTableRestoreStatusResponse> {
            serializer = DescribeTableRestoreStatusOperationSerializer()
            deserializer = DescribeTableRestoreStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTableRestoreStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.
     *
     * The following are limitations for `DescribeTags`:
     * + You cannot specify an ARN and a resource-type value together in the same request.
     * + You cannot use the `MaxRecords` and `Marker` parameters together with the ARN parameter.
     * + The `MaxRecords` parameter can be a range from 10 to 50 results to return in a request.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all resources that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:
     * + If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.
     * + If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * + If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * + If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.
     */
    override suspend fun describeUsageLimits(input: DescribeUsageLimitsRequest): DescribeUsageLimitsResponse {
        val op = SdkHttpOperation.build<DescribeUsageLimitsRequest, DescribeUsageLimitsResponse> {
            serializer = DescribeUsageLimitsOperationSerializer()
            deserializer = DescribeUsageLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUsageLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    override suspend fun disableLogging(input: DisableLoggingRequest): DisableLoggingResponse {
        val op = SdkHttpOperation.build<DisableLoggingRequest, DisableLoggingResponse> {
            serializer = DisableLoggingOperationSerializer()
            deserializer = DisableLoggingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableLogging"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     *
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the key in the destination region.
     */
    override suspend fun disableSnapshotCopy(input: DisableSnapshotCopyRequest): DisableSnapshotCopyResponse {
        val op = SdkHttpOperation.build<DisableSnapshotCopyRequest, DisableSnapshotCopyResponse> {
            serializer = DisableSnapshotCopyOperationSerializer()
            deserializer = DisableSnapshotCopyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableSnapshotCopy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * From a datashare consumer account, remove association for the specified datashare.
     */
    override suspend fun disassociateDataShareConsumer(input: DisassociateDataShareConsumerRequest): DisassociateDataShareConsumerResponse {
        val op = SdkHttpOperation.build<DisassociateDataShareConsumerRequest, DisassociateDataShareConsumerResponse> {
            serializer = DisassociateDataShareConsumerOperationSerializer()
            deserializer = DisassociateDataShareConsumerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDataShareConsumer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    override suspend fun enableLogging(input: EnableLoggingRequest): EnableLoggingResponse {
        val op = SdkHttpOperation.build<EnableLoggingRequest, EnableLoggingResponse> {
            serializer = EnableLoggingOperationSerializer()
            deserializer = EnableLoggingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableLogging"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     */
    override suspend fun enableSnapshotCopy(input: EnableSnapshotCopyRequest): EnableSnapshotCopyResponse {
        val op = SdkHttpOperation.build<EnableSnapshotCopyRequest, EnableSnapshotCopyResponse> {
            serializer = EnableSnapshotCopyOperationSerializer()
            deserializer = EnableSnapshotCopyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableSnapshotCopy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with `IAM:` if `AutoCreate` is `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see [Using IAM Authentication to Generate Database User Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html) in the Amazon Redshift Cluster Management Guide.
     *
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Resource Policies for GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources) in the Amazon Redshift Cluster Management Guide.
     *
     * If the `DbGroups` parameter is specified, the IAM policy must allow the `redshift:JoinGroup` action with access to the listed `dbgroups`.
     *
     * In addition, if the `AutoCreate` parameter is set to `True`, then the policy must include the `redshift:CreateClusterUser` permission.
     *
     * If the `DbName` parameter is specified, the IAM policy must allow access to the resource `dbname` for the specified database name.
     */
    override suspend fun getClusterCredentials(input: GetClusterCredentialsRequest): GetClusterCredentialsResponse {
        val op = SdkHttpOperation.build<GetClusterCredentialsRequest, GetClusterCredentialsResponse> {
            serializer = GetClusterCredentialsOperationSerializer()
            deserializer = GetClusterCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClusterCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see [IAM Identities (users, user groups, and roles)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html) in the Amazon Web Services Identity and Access Management User Guide.
     *
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Using identity-based policies (IAM policies)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide.
     */
    override suspend fun getClusterCredentialsWithIam(input: GetClusterCredentialsWithIamRequest): GetClusterCredentialsWithIamResponse {
        val op = SdkHttpOperation.build<GetClusterCredentialsWithIamRequest, GetClusterCredentialsWithIamResponse> {
            serializer = GetClusterCredentialsWithIAMOperationSerializer()
            deserializer = GetClusterCredentialsWithIAMOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClusterCredentialsWithIAM"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.
     */
    override suspend fun getReservedNodeExchangeConfigurationOptions(input: GetReservedNodeExchangeConfigurationOptionsRequest): GetReservedNodeExchangeConfigurationOptionsResponse {
        val op = SdkHttpOperation.build<GetReservedNodeExchangeConfigurationOptionsRequest, GetReservedNodeExchangeConfigurationOptionsResponse> {
            serializer = GetReservedNodeExchangeConfigurationOptionsOperationSerializer()
            deserializer = GetReservedNodeExchangeConfigurationOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservedNodeExchangeConfigurationOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.
     */
    override suspend fun getReservedNodeExchangeOfferings(input: GetReservedNodeExchangeOfferingsRequest): GetReservedNodeExchangeOfferingsResponse {
        val op = SdkHttpOperation.build<GetReservedNodeExchangeOfferingsRequest, GetReservedNodeExchangeOfferingsResponse> {
            serializer = GetReservedNodeExchangeOfferingsOperationSerializer()
            deserializer = GetReservedNodeExchangeOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservedNodeExchangeOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies whether a cluster can use AQUA (Advanced Query Accelerator).
     */
    override suspend fun modifyAquaConfiguration(input: ModifyAquaConfigurationRequest): ModifyAquaConfigurationResponse {
        val op = SdkHttpOperation.build<ModifyAquaConfigurationRequest, ModifyAquaConfigurationResponse> {
            serializer = ModifyAquaConfigurationOperationSerializer()
            deserializer = ModifyAquaConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyAquaConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an authentication profile.
     */
    override suspend fun modifyAuthenticationProfile(input: ModifyAuthenticationProfileRequest): ModifyAuthenticationProfileResponse {
        val op = SdkHttpOperation.build<ModifyAuthenticationProfileRequest, ModifyAuthenticationProfileResponse> {
            serializer = ModifyAuthenticationProfileOperationSerializer()
            deserializer = ModifyAuthenticationProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyAuthenticationProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for a cluster.
     *
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.
     *
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse {
        val op = SdkHttpOperation.build<ModifyClusterRequest, ModifyClusterResponse> {
            serializer = ModifyClusterOperationSerializer()
            deserializer = ModifyClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.
     */
    override suspend fun modifyClusterDbRevision(input: ModifyClusterDbRevisionRequest): ModifyClusterDbRevisionResponse {
        val op = SdkHttpOperation.build<ModifyClusterDbRevisionRequest, ModifyClusterDbRevisionResponse> {
            serializer = ModifyClusterDbRevisionOperationSerializer()
            deserializer = ModifyClusterDbRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterDbRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun modifyClusterIamRoles(input: ModifyClusterIamRolesRequest): ModifyClusterIamRolesResponse {
        val op = SdkHttpOperation.build<ModifyClusterIamRolesRequest, ModifyClusterIamRolesResponse> {
            serializer = ModifyClusterIamRolesOperationSerializer()
            deserializer = ModifyClusterIamRolesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterIamRoles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the maintenance settings of a cluster.
     */
    override suspend fun modifyClusterMaintenance(input: ModifyClusterMaintenanceRequest): ModifyClusterMaintenanceResponse {
        val op = SdkHttpOperation.build<ModifyClusterMaintenanceRequest, ModifyClusterMaintenanceResponse> {
            serializer = ModifyClusterMaintenanceOperationSerializer()
            deserializer = ModifyClusterMaintenanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterMaintenance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun modifyClusterParameterGroup(input: ModifyClusterParameterGroupRequest): ModifyClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ModifyClusterParameterGroupRequest, ModifyClusterParameterGroupResponse> {
            serializer = ModifyClusterParameterGroupOperationSerializer()
            deserializer = ModifyClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for a snapshot.
     *
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     */
    override suspend fun modifyClusterSnapshot(input: ModifyClusterSnapshotRequest): ModifyClusterSnapshotResponse {
        val op = SdkHttpOperation.build<ModifyClusterSnapshotRequest, ModifyClusterSnapshotResponse> {
            serializer = ModifyClusterSnapshotOperationSerializer()
            deserializer = ModifyClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a snapshot schedule for a cluster.
     */
    override suspend fun modifyClusterSnapshotSchedule(input: ModifyClusterSnapshotScheduleRequest): ModifyClusterSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<ModifyClusterSnapshotScheduleRequest, ModifyClusterSnapshotScheduleResponse> {
            serializer = ModifyClusterSnapshotScheduleOperationSerializer()
            deserializer = ModifyClusterSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterSnapshotSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.
     */
    override suspend fun modifyClusterSubnetGroup(input: ModifyClusterSubnetGroupRequest): ModifyClusterSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyClusterSubnetGroupRequest, ModifyClusterSubnetGroupResponse> {
            serializer = ModifyClusterSubnetGroupOperationSerializer()
            deserializer = ModifyClusterSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClusterSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a Redshift-managed VPC endpoint.
     */
    override suspend fun modifyEndpointAccess(input: ModifyEndpointAccessRequest): ModifyEndpointAccessResponse {
        val op = SdkHttpOperation.build<ModifyEndpointAccessRequest, ModifyEndpointAccessResponse> {
            serializer = ModifyEndpointAccessOperationSerializer()
            deserializer = ModifyEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing Amazon Redshift event notification subscription.
     */
    override suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse {
        val op = SdkHttpOperation.build<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse> {
            serializer = ModifyEventSubscriptionOperationSerializer()
            deserializer = ModifyEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a scheduled action.
     */
    override suspend fun modifyScheduledAction(input: ModifyScheduledActionRequest): ModifyScheduledActionResponse {
        val op = SdkHttpOperation.build<ModifyScheduledActionRequest, ModifyScheduledActionResponse> {
            serializer = ModifyScheduledActionOperationSerializer()
            deserializer = ModifyScheduledActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyScheduledAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.
     */
    override suspend fun modifySnapshotCopyRetentionPeriod(input: ModifySnapshotCopyRetentionPeriodRequest): ModifySnapshotCopyRetentionPeriodResponse {
        val op = SdkHttpOperation.build<ModifySnapshotCopyRetentionPeriodRequest, ModifySnapshotCopyRetentionPeriodResponse> {
            serializer = ModifySnapshotCopyRetentionPeriodOperationSerializer()
            deserializer = ModifySnapshotCopyRetentionPeriodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySnapshotCopyRetentionPeriod"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     */
    override suspend fun modifySnapshotSchedule(input: ModifySnapshotScheduleRequest): ModifySnapshotScheduleResponse {
        val op = SdkHttpOperation.build<ModifySnapshotScheduleRequest, ModifySnapshotScheduleResponse> {
            serializer = ModifySnapshotScheduleOperationSerializer()
            deserializer = ModifySnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySnapshotSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
     */
    override suspend fun modifyUsageLimit(input: ModifyUsageLimitRequest): ModifyUsageLimitResponse {
        val op = SdkHttpOperation.build<ModifyUsageLimitRequest, ModifyUsageLimitResponse> {
            serializer = ModifyUsageLimitOperationSerializer()
            deserializer = ModifyUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Pauses a cluster.
     */
    override suspend fun pauseCluster(input: PauseClusterRequest): PauseClusterResponse {
        val op = SdkHttpOperation.build<PauseClusterRequest, PauseClusterResponse> {
            serializer = PauseClusterOperationSerializer()
            deserializer = PauseClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PauseCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun purchaseReservedNodeOffering(input: PurchaseReservedNodeOfferingRequest): PurchaseReservedNodeOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedNodeOfferingRequest, PurchaseReservedNodeOfferingResponse> {
            serializer = PurchaseReservedNodeOfferingOperationSerializer()
            deserializer = PurchaseReservedNodeOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseReservedNodeOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to `rebooting`. A cluster event is created when the reboot is completed. Any pending cluster modifications (see ModifyCluster) are applied at this reboot. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun rebootCluster(input: RebootClusterRequest): RebootClusterResponse {
        val op = SdkHttpOperation.build<RebootClusterRequest, RebootClusterResponse> {
            serializer = RebootClusterOperationSerializer()
            deserializer = RebootClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * From a datashare consumer account, rejects the specified datashare.
     */
    override suspend fun rejectDataShare(input: RejectDataShareRequest): RejectDataShareResponse {
        val op = SdkHttpOperation.build<RejectDataShareRequest, RejectDataShareResponse> {
            serializer = RejectDataShareOperationSerializer()
            deserializer = RejectDataShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectDataShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the *ResetAllParameters* parameter. For parameter changes to take effect you must reboot any associated clusters.
     */
    override suspend fun resetClusterParameterGroup(input: ResetClusterParameterGroupRequest): ResetClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ResetClusterParameterGroupRequest, ResetClusterParameterGroupResponse> {
            serializer = ResetClusterParameterGroupOperationSerializer()
            deserializer = ResetClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetClusterParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.
     *
     * Elastic resize operations have the following restrictions:
     * + You can only resize clusters of the following types:
     *    + dc1.large (if your cluster is in a VPC)
     *    + dc1.8xlarge (if your cluster is in a VPC)
     *    + dc2.large
     *    + dc2.8xlarge
     *    + ds2.xlarge
     *    + ds2.8xlarge
     *    + ra3.xlplus
     *    + ra3.4xlarge
     *    + ra3.16xlarge
     * + The type of nodes that you add must match the node type for the cluster.
     */
    override suspend fun resizeCluster(input: ResizeClusterRequest): ResizeClusterResponse {
        val op = SdkHttpOperation.build<ResizeClusterRequest, ResizeClusterResponse> {
            serializer = ResizeClusterOperationSerializer()
            deserializer = ResizeClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResizeCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.
     *
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun restoreFromClusterSnapshot(input: RestoreFromClusterSnapshotRequest): RestoreFromClusterSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreFromClusterSnapshotRequest, RestoreFromClusterSnapshotResponse> {
            serializer = RestoreFromClusterSnapshotOperationSerializer()
            deserializer = RestoreFromClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreFromClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.
     *
     * You cannot use `RestoreTableFromClusterSnapshot` to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call `RestoreTableFromClusterSnapshot`. When you have renamed your original table, then you can pass the original name of the table as the `NewTableName` parameter value in the call to `RestoreTableFromClusterSnapshot`. This way, you can replace the original table with the table created from the snapshot.
     */
    override suspend fun restoreTableFromClusterSnapshot(input: RestoreTableFromClusterSnapshotRequest): RestoreTableFromClusterSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreTableFromClusterSnapshotRequest, RestoreTableFromClusterSnapshotResponse> {
            serializer = RestoreTableFromClusterSnapshotOperationSerializer()
            deserializer = RestoreTableFromClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreTableFromClusterSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resumes a paused cluster.
     */
    override suspend fun resumeCluster(input: ResumeClusterRequest): ResumeClusterResponse {
        val op = SdkHttpOperation.build<ResumeClusterRequest, ResumeClusterResponse> {
            serializer = ResumeClusterOperationSerializer()
            deserializer = ResumeClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResumeCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun revokeClusterSecurityGroupIngress(input: RevokeClusterSecurityGroupIngressRequest): RevokeClusterSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<RevokeClusterSecurityGroupIngressRequest, RevokeClusterSecurityGroupIngressResponse> {
            serializer = RevokeClusterSecurityGroupIngressOperationSerializer()
            deserializer = RevokeClusterSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeClusterSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Revokes access to a cluster.
     */
    override suspend fun revokeEndpointAccess(input: RevokeEndpointAccessRequest): RevokeEndpointAccessResponse {
        val op = SdkHttpOperation.build<RevokeEndpointAccessRequest, RevokeEndpointAccessResponse> {
            serializer = RevokeEndpointAccessOperationSerializer()
            deserializer = RevokeEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    override suspend fun revokeSnapshotAccess(input: RevokeSnapshotAccessRequest): RevokeSnapshotAccessResponse {
        val op = SdkHttpOperation.build<RevokeSnapshotAccessRequest, RevokeSnapshotAccessResponse> {
            serializer = RevokeSnapshotAccessOperationSerializer()
            deserializer = RevokeSnapshotAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeSnapshotAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rotates the encryption keys for a cluster.
     */
    override suspend fun rotateEncryptionKey(input: RotateEncryptionKeyRequest): RotateEncryptionKeyResponse {
        val op = SdkHttpOperation.build<RotateEncryptionKeyRequest, RotateEncryptionKeyResponse> {
            serializer = RotateEncryptionKeyOperationSerializer()
            deserializer = RotateEncryptionKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RotateEncryptionKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of a partner integration.
     */
    override suspend fun updatePartnerStatus(input: UpdatePartnerStatusRequest): UpdatePartnerStatusResponse {
        val op = SdkHttpOperation.build<UpdatePartnerStatusRequest, UpdatePartnerStatusResponse> {
            serializer = UpdatePartnerStatusOperationSerializer()
            deserializer = UpdatePartnerStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePartnerStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "redshift")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
