// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request parameters represent the input of a request to run a SQL statement against a database.
 */
public class ExecuteStatementRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.
     *
     * For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures.
     */
    public val continueAfterTimeout: kotlin.Boolean = builder.continueAfterTimeout
    /**
     * The name of the database.
     */
    public val database: kotlin.String? = builder.database
    /**
     * A value that indicates whether to format the result set as a single JSON string. This parameter only applies to `SELECT` statements and is ignored for other types of statements. Allowed values are `NONE` and `JSON`. The default value is `NONE`. The result is returned in the `formattedRecords` field.
     *
     * For usage information about the JSON format for result sets, see [Using the Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     */
    public val formatRecordsAs: aws.sdk.kotlin.services.rdsdata.model.RecordsFormatType? = builder.formatRecordsAs
    /**
     * A value that indicates whether to include metadata in the results.
     */
    public val includeResultMetadata: kotlin.Boolean = builder.includeResultMetadata
    /**
     * The parameters for the SQL statement.
     *
     * Array parameters are not supported.
     */
    public val parameters: List<SqlParameter>? = builder.parameters
    /**
     * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Options that control how the result set is returned.
     */
    public val resultSetOptions: aws.sdk.kotlin.services.rdsdata.model.ResultSetOptions? = builder.resultSetOptions
    /**
     * The name of the database schema.
     *
     * Currently, the `schema` parameter isn't supported.
     */
    public val schema: kotlin.String? = builder.schema
    /**
     * The ARN of the secret that enables access to the DB cluster. Enter the database user name and password for the credentials in the secret.
     *
     * For information about creating the secret, see [Create a database secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The SQL statement to run.
     */
    public val sql: kotlin.String = requireNotNull(builder.sql) { "A non-null value must be provided for sql" }
    /**
     * The identifier of a transaction that was started by using the `BeginTransaction` operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.
     *
     * If the SQL statement is not part of a transaction, don't set this parameter.
     */
    public val transactionId: kotlin.String? = builder.transactionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteStatementRequest(")
        append("continueAfterTimeout=$continueAfterTimeout,")
        append("database=$database,")
        append("formatRecordsAs=$formatRecordsAs,")
        append("includeResultMetadata=$includeResultMetadata,")
        append("parameters=$parameters,")
        append("resourceArn=$resourceArn,")
        append("resultSetOptions=$resultSetOptions,")
        append("schema=$schema,")
        append("secretArn=$secretArn,")
        append("sql=$sql,")
        append("transactionId=$transactionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = continueAfterTimeout.hashCode()
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (formatRecordsAs?.hashCode() ?: 0)
        result = 31 * result + (includeResultMetadata.hashCode())
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (resultSetOptions?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (sql.hashCode())
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteStatementRequest

        if (continueAfterTimeout != other.continueAfterTimeout) return false
        if (database != other.database) return false
        if (formatRecordsAs != other.formatRecordsAs) return false
        if (includeResultMetadata != other.includeResultMetadata) return false
        if (parameters != other.parameters) return false
        if (resourceArn != other.resourceArn) return false
        if (resultSetOptions != other.resultSetOptions) return false
        if (schema != other.schema) return false
        if (secretArn != other.secretArn) return false
        if (sql != other.sql) return false
        if (transactionId != other.transactionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.
         *
         * For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures.
         */
        public var continueAfterTimeout: kotlin.Boolean = false
        /**
         * The name of the database.
         */
        public var database: kotlin.String? = null
        /**
         * A value that indicates whether to format the result set as a single JSON string. This parameter only applies to `SELECT` statements and is ignored for other types of statements. Allowed values are `NONE` and `JSON`. The default value is `NONE`. The result is returned in the `formattedRecords` field.
         *
         * For usage information about the JSON format for result sets, see [Using the Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         */
        public var formatRecordsAs: aws.sdk.kotlin.services.rdsdata.model.RecordsFormatType? = null
        /**
         * A value that indicates whether to include metadata in the results.
         */
        public var includeResultMetadata: kotlin.Boolean = false
        /**
         * The parameters for the SQL statement.
         *
         * Array parameters are not supported.
         */
        public var parameters: List<SqlParameter>? = null
        /**
         * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Options that control how the result set is returned.
         */
        public var resultSetOptions: aws.sdk.kotlin.services.rdsdata.model.ResultSetOptions? = null
        /**
         * The name of the database schema.
         *
         * Currently, the `schema` parameter isn't supported.
         */
        public var schema: kotlin.String? = null
        /**
         * The ARN of the secret that enables access to the DB cluster. Enter the database user name and password for the credentials in the secret.
         *
         * For information about creating the secret, see [Create a database secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * The SQL statement to run.
         */
        public var sql: kotlin.String? = null
        /**
         * The identifier of a transaction that was started by using the `BeginTransaction` operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.
         *
         * If the SQL statement is not part of a transaction, don't set this parameter.
         */
        public var transactionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementRequest) : this() {
            this.continueAfterTimeout = x.continueAfterTimeout
            this.database = x.database
            this.formatRecordsAs = x.formatRecordsAs
            this.includeResultMetadata = x.includeResultMetadata
            this.parameters = x.parameters
            this.resourceArn = x.resourceArn
            this.resultSetOptions = x.resultSetOptions
            this.schema = x.schema
            this.secretArn = x.secretArn
            this.sql = x.sql
            this.transactionId = x.transactionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementRequest = ExecuteStatementRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rdsdata.model.ResultSetOptions] inside the given [block]
         */
        public fun resultSetOptions(block: aws.sdk.kotlin.services.rdsdata.model.ResultSetOptions.Builder.() -> kotlin.Unit) {
            this.resultSetOptions = aws.sdk.kotlin.services.rdsdata.model.ResultSetOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            if (secretArn == null) secretArn = ""
            if (sql == null) sql = ""
            return this
        }
    }
}
