// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.serde

import aws.sdk.kotlin.services.rdsdata.model.BatchExecuteStatementResponse
import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.sdk.kotlin.services.rdsdata.model.UpdateResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchExecuteStatementOperationDeserializer: HttpDeserializer.NonStreaming<BatchExecuteStatementResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchExecuteStatementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchExecuteStatementError(context, call, payload)
        }
        val builder = BatchExecuteStatementResponse.Builder()

        if (payload != null) {
            deserializeBatchExecuteStatementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchExecuteStatementError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DatabaseNotFoundException" -> DatabaseNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DatabaseUnavailableException" -> DatabaseUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TransactionNotFoundException" -> TransactionNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DatabaseErrorException" -> DatabaseErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HttpEndpointNotEnabledException" -> HttpEndpointNotEnabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "StatementTimeoutException" -> StatementTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecretException" -> InvalidSecretExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SecretsErrorException" -> SecretsErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchExecuteStatementOperationBody(builder: BatchExecuteStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UPDATERESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("updateResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UPDATERESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UPDATERESULTS_DESCRIPTOR.index -> builder.updateResults =
                    deserializer.deserializeList(UPDATERESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UpdateResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUpdateResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
