// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.serde

import aws.sdk.kotlin.services.rdsdata.model.ColumnMetadata
import aws.sdk.kotlin.services.rdsdata.model.ExecuteStatementResponse
import aws.sdk.kotlin.services.rdsdata.model.Field
import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ExecuteStatementOperationDeserializer: HttpDeserialize<ExecuteStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ExecuteStatementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExecuteStatementError(context, call)
        }
        val builder = ExecuteStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteStatementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwExecuteStatementError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DatabaseNotFoundException" -> DatabaseNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseUnavailableException" -> DatabaseUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedResultException" -> UnsupportedResultExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionNotFoundException" -> TransactionNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseErrorException" -> DatabaseErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "HttpEndpointNotEnabledException" -> HttpEndpointNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "StatementTimeoutException" -> StatementTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidSecretException" -> InvalidSecretExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "SecretsErrorException" -> SecretsErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteStatementOperationBody(builder: ExecuteStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLUMNMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("columnMetadata"))
    val FORMATTEDRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("formattedRecords"))
    val GENERATEDFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("generatedFields"))
    val NUMBEROFRECORDSUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("numberOfRecordsUpdated"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("records"))
    val RECORDS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNMETADATA_DESCRIPTOR)
        field(FORMATTEDRECORDS_DESCRIPTOR)
        field(GENERATEDFIELDS_DESCRIPTOR)
        field(NUMBEROFRECORDSUPDATED_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLUMNMETADATA_DESCRIPTOR.index -> builder.columnMetadata =
                    deserializer.deserializeList(COLUMNMETADATA_DESCRIPTOR) {
                        val col0 = mutableListOf<ColumnMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeColumnMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FORMATTEDRECORDS_DESCRIPTOR.index -> builder.formattedRecords = deserializeString()
                GENERATEDFIELDS_DESCRIPTOR.index -> builder.generatedFields =
                    deserializer.deserializeList(GENERATEDFIELDS_DESCRIPTOR) {
                        val col0 = mutableListOf<Field>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFieldDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NUMBEROFRECORDSUPDATED_DESCRIPTOR.index -> builder.numberOfRecordsUpdated = deserializeLong()
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Field>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(RECORDS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Field>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeFieldDocument(deserializer) } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
