// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.serde

import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.sdk.kotlin.services.rdsdata.model.RollbackTransactionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RollbackTransactionOperationDeserializer: HttpDeserialize<RollbackTransactionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RollbackTransactionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRollbackTransactionError(context, call)
        }
        val builder = RollbackTransactionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRollbackTransactionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRollbackTransactionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DatabaseNotFoundException" -> DatabaseNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseUnavailableException" -> DatabaseUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionNotFoundException" -> TransactionNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseErrorException" -> DatabaseErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "HttpEndpointNotEnabledException" -> HttpEndpointNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "StatementTimeoutException" -> StatementTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidSecretException" -> InvalidSecretExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "SecretsErrorException" -> SecretsErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRollbackTransactionOperationBody(builder: RollbackTransactionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TRANSACTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("transactionStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TRANSACTIONSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TRANSACTIONSTATUS_DESCRIPTOR.index -> builder.transactionStatus = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
