// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.serde

import aws.sdk.kotlin.services.rdsdata.model.BeginTransactionResponse
import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BeginTransactionOperationDeserializer: HttpDeserialize<BeginTransactionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BeginTransactionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBeginTransactionError(context, call)
        }
        val builder = BeginTransactionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBeginTransactionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBeginTransactionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DatabaseNotFoundException" -> DatabaseNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseUnavailableException" -> DatabaseUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionNotFoundException" -> TransactionNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DatabaseErrorException" -> DatabaseErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "HttpEndpointNotEnabledException" -> HttpEndpointNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "StatementTimeoutException" -> StatementTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidSecretException" -> InvalidSecretExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "SecretsErrorException" -> SecretsErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBeginTransactionOperationBody(builder: BeginTransactionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TRANSACTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("transactionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TRANSACTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TRANSACTIONID_DESCRIPTOR.index -> builder.transactionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
