// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.transform

import aws.sdk.kotlin.services.rdsdata.model.BatchExecuteStatementResponse
import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.sdk.kotlin.services.rdsdata.model.UpdateResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchExecuteStatementOperationDeserializer: HttpDeserialize<BatchExecuteStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchExecuteStatementResponse {
        if (!response.status.isSuccess()) {
            throwBatchExecuteStatementError(context, response)
        }
        val builder = BatchExecuteStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchExecuteStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchExecuteStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedResponse)
        "StatementTimeoutException" -> StatementTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchExecuteStatementOperationBody(builder: BatchExecuteStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UPDATERESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("updateResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UPDATERESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UPDATERESULTS_DESCRIPTOR.index -> builder.updateResults =
                    deserializer.deserializeList(UPDATERESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UpdateResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUpdateResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
