// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rdsdata.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.rdsdata.model.ExecuteSqlResponse
import aws.sdk.kotlin.services.rdsdata.model.RdsDataException
import aws.sdk.kotlin.services.rdsdata.model.SqlStatementResult
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ExecuteSqlOperationDeserializer: HttpDeserialize<ExecuteSqlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ExecuteSqlResponse {
        if (!response.status.isSuccess()) {
            throwExecuteSqlError(context, response)
        }
        val builder = ExecuteSqlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteSqlOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwExecuteSqlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RdsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableError" -> ServiceUnavailableErrorDeserializer().deserialize(context, wrappedResponse)
        else -> RdsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteSqlOperationBody(builder: ExecuteSqlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SQLSTATEMENTRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sqlStatementResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SQLSTATEMENTRESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SQLSTATEMENTRESULTS_DESCRIPTOR.index -> builder.sqlStatementResults =
                    deserializer.deserializeList(SQLSTATEMENTRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SqlStatementResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSqlStatementResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
