/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.rds.serde;

import aws.sdk.kotlin.services.rds.model.RdsException;
import aws.sdk.kotlin.services.rds.model.StartDbInstanceResponse;
import aws.sdk.kotlin.services.rds.serde.AuthorizationNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.rds.serde.DbClusterNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbInstanceDocumentDeserializerKt;
import aws.sdk.kotlin.services.rds.serde.DbInstanceNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSubnetGroupDoesNotCoverEnoughAzsDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSubnetGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InsufficientDbInstanceCapacityFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidDbClusterStateFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidDbInstanceStateFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidSubnetDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidVpcNetworkStateFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.KmsKeyNotAccessibleFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwStartDbInstanceError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeStartDBInstanceOperationBody", "", "builder", "Laws/sdk/kotlin/services/rds/model/StartDbInstanceResponse$Builder;", "rds"})
@SourceDebugExtension(value={"SMAP\nStartDBInstanceOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartDBInstanceOperationDeserializer.kt\naws/sdk/kotlin/services/rds/serde/StartDBInstanceOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class StartDBInstanceOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwStartDbInstanceError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$1 = false;
                $i$a$-checkNotNull-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new RdsException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-StartDBInstanceOperationDeserializerKt$throwStartDbInstanceError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case -293119594: {
                if (var7_9.equals("InvalidDBClusterStateFault")) {
                    tmp = 1;
                }
                break;
            }
            case 244042441: {
                if (var7_9.equals("DBSubnetGroupDoesNotCoverEnoughAZs")) {
                    tmp = 2;
                }
                break;
            }
            case -61683088: {
                if (var7_9.equals("InsufficientDBInstanceCapacity")) {
                    tmp = 3;
                }
                break;
            }
            case -1210651454: {
                if (var7_9.equals("DBInstanceNotFound")) {
                    tmp = 4;
                }
                break;
            }
            case 577905847: {
                if (var7_9.equals("DBClusterNotFoundFault")) {
                    tmp = 5;
                }
                break;
            }
            case 1054393197: {
                if (var7_9.equals("InvalidVPCNetworkStateFault")) {
                    tmp = 6;
                }
                break;
            }
            case -992075065: {
                if (var7_9.equals("KMSKeyNotAccessibleFault")) {
                    tmp = 7;
                }
                break;
            }
            case 1070941071: {
                if (var7_9.equals("DBSubnetGroupNotFoundFault")) {
                    tmp = 8;
                }
                break;
            }
            case -147598360: {
                if (var7_9.equals("AuthorizationNotFound")) {
                    tmp = 9;
                }
                break;
            }
            case -1908742553: {
                if (var7_9.equals("InvalidDBInstanceState")) {
                    tmp = 10;
                }
                break;
            }
            case -379929580: {
                if (var7_9.equals("InvalidSubnet")) {
                    tmp = 11;
                }
                break;
            }
        }
        switch (tmp) {
            case 5: {
                v1 = new DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new RdsException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeStartDBInstanceOperationBody(StartDbInstanceResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "StartDBInstance");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"DBInstance")) {
                builder.setDbInstance(DbInstanceDocumentDeserializerKt.deserializeDbInstanceDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwStartDbInstanceError(ExecutionContext context, HttpCall call, byte[] payload) {
        return StartDBInstanceOperationDeserializerKt.throwStartDbInstanceError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeStartDBInstanceOperationBody(StartDbInstanceResponse.Builder builder, byte[] payload) {
        StartDBInstanceOperationDeserializerKt.deserializeStartDBInstanceOperationBody(builder, payload);
    }
}

