/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.rds.serde;

import aws.sdk.kotlin.services.rds.model.RdsException;
import aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Response;
import aws.sdk.kotlin.services.rds.serde.AuthorizationNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.rds.serde.BackupPolicyNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.CertificateNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbInstanceAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbInstanceDocumentDeserializerKt;
import aws.sdk.kotlin.services.rds.serde.DbParameterGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSecurityGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSubnetGroupDoesNotCoverEnoughAzsDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSubnetGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InstanceQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InsufficientDbInstanceCapacityFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidS3BucketFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidSubnetDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidVpcNetworkStateFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.KmsKeyNotAccessibleFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.NetworkTypeNotSupportedDeserializer;
import aws.sdk.kotlin.services.rds.serde.OptionGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.ProvisionedIopsNotAvailableInAzFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.StorageQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.StorageTypeNotSupportedFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwRestoreDbInstanceFromS3Error", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeRestoreDBInstanceFromS3OperationBody", "", "builder", "Laws/sdk/kotlin/services/rds/model/RestoreDbInstanceFromS3Response$Builder;", "rds"})
@SourceDebugExtension(value={"SMAP\nRestoreDBInstanceFromS3OperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestoreDBInstanceFromS3OperationDeserializer.kt\naws/sdk/kotlin/services/rds/serde/RestoreDBInstanceFromS3OperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class RestoreDBInstanceFromS3OperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwRestoreDbInstanceFromS3Error(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$1 = false;
                $i$a$-checkNotNull-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new RdsException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-RestoreDBInstanceFromS3OperationDeserializerKt$throwRestoreDbInstanceFromS3Error$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 237012577: {
                if (var7_9.equals("DBInstanceAlreadyExists")) {
                    tmp = 1;
                }
                break;
            }
            case 244042441: {
                if (var7_9.equals("DBSubnetGroupDoesNotCoverEnoughAZs")) {
                    tmp = 2;
                }
                break;
            }
            case -61683088: {
                if (var7_9.equals("InsufficientDBInstanceCapacity")) {
                    tmp = 3;
                }
                break;
            }
            case 1641224241: {
                if (var7_9.equals("ProvisionedIopsNotAvailableInAZFault")) {
                    tmp = 4;
                }
                break;
            }
            case -228524637: {
                if (var7_9.equals("NetworkTypeNotSupported")) {
                    tmp = 5;
                }
                break;
            }
            case -327701520: {
                if (var7_9.equals("StorageTypeNotSupported")) {
                    tmp = 6;
                }
                break;
            }
            case -1772584545: {
                if (var7_9.equals("BackupPolicyNotFoundFault")) {
                    tmp = 7;
                }
                break;
            }
            case 621784838: {
                if (var7_9.equals("CertificateNotFound")) {
                    tmp = 8;
                }
                break;
            }
            case -1095774973: {
                if (var7_9.equals("DBParameterGroupNotFound")) {
                    tmp = 9;
                }
                break;
            }
            case 653050753: {
                if (var7_9.equals("InvalidS3BucketFault")) {
                    tmp = 10;
                }
                break;
            }
            case -1150843863: {
                if (var7_9.equals("OptionGroupNotFoundFault")) {
                    tmp = 11;
                }
                break;
            }
            case -379929580: {
                if (var7_9.equals("InvalidSubnet")) {
                    tmp = 12;
                }
                break;
            }
            case 1054393197: {
                if (var7_9.equals("InvalidVPCNetworkStateFault")) {
                    tmp = 13;
                }
                break;
            }
            case -763272394: {
                if (var7_9.equals("InstanceQuotaExceeded")) {
                    tmp = 14;
                }
                break;
            }
            case -992075065: {
                if (var7_9.equals("KMSKeyNotAccessibleFault")) {
                    tmp = 15;
                }
                break;
            }
            case 1070941071: {
                if (var7_9.equals("DBSubnetGroupNotFoundFault")) {
                    tmp = 16;
                }
                break;
            }
            case -147598360: {
                if (var7_9.equals("AuthorizationNotFound")) {
                    tmp = 17;
                }
                break;
            }
            case 737072848: {
                if (var7_9.equals("DBSecurityGroupNotFound")) {
                    tmp = 18;
                }
                break;
            }
            case 300932944: {
                if (var7_9.equals("StorageQuotaExceeded")) {
                    tmp = 19;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v1 = new DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 16: {
                v1 = new DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 15: {
                v1 = new KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 14: {
                v1 = new InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 13: {
                v1 = new InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 19: {
                v1 = new StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 12: {
                v1 = new InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new CertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new NetworkTypeNotSupportedDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 18: {
                v1 = new DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new ProvisionedIopsNotAvailableInAzFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 17: {
                v1 = new AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new InvalidS3BucketFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new BackupPolicyNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new RdsException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeRestoreDBInstanceFromS3OperationBody(RestoreDbInstanceFromS3Response.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "RestoreDBInstanceFromS3");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"DBInstance")) {
                builder.setDbInstance(DbInstanceDocumentDeserializerKt.deserializeDbInstanceDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwRestoreDbInstanceFromS3Error(ExecutionContext context, HttpCall call, byte[] payload) {
        return RestoreDBInstanceFromS3OperationDeserializerKt.throwRestoreDbInstanceFromS3Error(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeRestoreDBInstanceFromS3OperationBody(RestoreDbInstanceFromS3Response.Builder builder, byte[] payload) {
        RestoreDBInstanceFromS3OperationDeserializerKt.deserializeRestoreDBInstanceFromS3OperationBody(builder, payload);
    }
}

