/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.rds.serde;

import aws.sdk.kotlin.services.rds.model.CopyDbSnapshotResponse;
import aws.sdk.kotlin.services.rds.model.RdsException;
import aws.sdk.kotlin.services.rds.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.rds.serde.CustomAvailabilityZoneNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSnapshotAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.DbSnapshotDocumentDeserializerKt;
import aws.sdk.kotlin.services.rds.serde.DbSnapshotNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.InvalidDbSnapshotStateFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.KmsKeyNotAccessibleFaultDeserializer;
import aws.sdk.kotlin.services.rds.serde.SnapshotQuotaExceededFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwCopyDbSnapshotError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeCopyDBSnapshotOperationBody", "", "builder", "Laws/sdk/kotlin/services/rds/model/CopyDbSnapshotResponse$Builder;", "rds"})
@SourceDebugExtension(value={"SMAP\nCopyDBSnapshotOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyDBSnapshotOperationDeserializer.kt\naws/sdk/kotlin/services/rds/serde/CopyDBSnapshotOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class CopyDBSnapshotOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwCopyDbSnapshotError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$1 = false;
                $i$a$-checkNotNull-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new RdsException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-CopyDBSnapshotOperationDeserializerKt$throwCopyDbSnapshotError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case -1660500377: {
                if (var7_9.equals("SnapshotQuotaExceeded")) {
                    tmp = 1;
                }
                break;
            }
            case 671812248: {
                if (var7_9.equals("InvalidDBSnapshotState")) {
                    tmp = 2;
                }
                break;
            }
            case -660215406: {
                if (var7_9.equals("DBSnapshotAlreadyExists")) {
                    tmp = 3;
                }
                break;
            }
            case -992075065: {
                if (var7_9.equals("KMSKeyNotAccessibleFault")) {
                    tmp = 4;
                }
                break;
            }
            case 477794033: {
                if (var7_9.equals("DBSnapshotNotFound")) {
                    tmp = 5;
                }
                break;
            }
            case -860334617: {
                if (var7_9.equals("CustomAvailabilityZoneNotFound")) {
                    tmp = 6;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v1 = new SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new DbSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new CustomAvailabilityZoneNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new InvalidDbSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new RdsException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeCopyDBSnapshotOperationBody(CopyDbSnapshotResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "CopyDBSnapshot");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"DBSnapshot")) {
                builder.setDbSnapshot(DbSnapshotDocumentDeserializerKt.deserializeDbSnapshotDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwCopyDbSnapshotError(ExecutionContext context, HttpCall call, byte[] payload) {
        return CopyDBSnapshotOperationDeserializerKt.throwCopyDbSnapshotError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeCopyDBSnapshotOperationBody(CopyDbSnapshotResponse.Builder builder, byte[] payload) {
        CopyDBSnapshotOperationDeserializerKt.deserializeCopyDBSnapshotOperationBody(builder, payload);
    }
}

