// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.AuthScheme
import aws.sdk.kotlin.services.rds.model.ClientPasswordAuthType
import aws.sdk.kotlin.services.rds.model.IamAuthMode
import aws.sdk.kotlin.services.rds.model.UserAuthConfigInfo
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeUserAuthConfigInfoDocument(reader: XmlTagReader): UserAuthConfigInfo {
    val builder = UserAuthConfigInfo.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Description com.amazonaws.rds#UserAuthConfigInfo$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // UserName com.amazonaws.rds#UserAuthConfigInfo$UserName
            "UserName" -> builder.userName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AuthScheme com.amazonaws.rds#UserAuthConfigInfo$AuthScheme
            "AuthScheme" -> builder.authScheme = curr.tryData()
                .parse { AuthScheme.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#AuthScheme`)" }
            // SecretArn com.amazonaws.rds#UserAuthConfigInfo$SecretArn
            "SecretArn" -> builder.secretArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IAMAuth com.amazonaws.rds#UserAuthConfigInfo$IAMAuth
            "IAMAuth" -> builder.iamAuth = curr.tryData()
                .parse { IamAuthMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#IAMAuthMode`)" }
            // ClientPasswordAuthType com.amazonaws.rds#UserAuthConfigInfo$ClientPasswordAuthType
            "ClientPasswordAuthType" -> builder.clientPasswordAuthType = curr.tryData()
                .parse { ClientPasswordAuthType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ClientPasswordAuthType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
