// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class StopDBInstanceAutomatedBackupsReplicationOperationDeserializer: HttpDeserializer.NonStreaming<StopDbInstanceAutomatedBackupsReplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StopDbInstanceAutomatedBackupsReplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStopDbInstanceAutomatedBackupsReplicationError(context, call, payload)
        }
        val builder = StopDbInstanceAutomatedBackupsReplicationResponse.Builder()

        if (payload != null) {
            deserializeStopDBInstanceAutomatedBackupsReplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStopDbInstanceAutomatedBackupsReplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopDBInstanceAutomatedBackupsReplicationOperationBody(builder: StopDbInstanceAutomatedBackupsReplicationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "StopDBInstanceAutomatedBackupsReplication")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceAutomatedBackup com.amazonaws.rds#StopDBInstanceAutomatedBackupsReplicationResult$DBInstanceAutomatedBackup
            "DBInstanceAutomatedBackup" -> builder.dbInstanceAutomatedBackup = deserializeDbInstanceAutomatedBackupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
