// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class StartDBInstanceAutomatedBackupsReplicationOperationDeserializer: HttpDeserializer.NonStreaming<StartDbInstanceAutomatedBackupsReplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartDbInstanceAutomatedBackupsReplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartDbInstanceAutomatedBackupsReplicationError(context, call, payload)
        }
        val builder = StartDbInstanceAutomatedBackupsReplicationResponse.Builder()

        if (payload != null) {
            deserializeStartDBInstanceAutomatedBackupsReplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartDbInstanceAutomatedBackupsReplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceAutomatedBackupQuotaExceeded" -> DbInstanceAutomatedBackupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartDBInstanceAutomatedBackupsReplicationOperationBody(builder: StartDbInstanceAutomatedBackupsReplicationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "StartDBInstanceAutomatedBackupsReplication")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceAutomatedBackup com.amazonaws.rds#StartDBInstanceAutomatedBackupsReplicationResult$DBInstanceAutomatedBackup
            "DBInstanceAutomatedBackup" -> builder.dbInstanceAutomatedBackup = deserializeDbInstanceAutomatedBackupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
