// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StartActivityStreamResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class StartActivityStreamOperationDeserializer: HttpDeserializer.NonStreaming<StartActivityStreamResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartActivityStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartActivityStreamError(context, call, payload)
        }
        val builder = StartActivityStreamResponse.Builder()

        if (payload != null) {
            deserializeStartActivityStreamOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartActivityStreamError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartActivityStreamOperationBody(builder: StartActivityStreamResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "StartActivityStream")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplyImmediately com.amazonaws.rds#StartActivityStreamResponse$ApplyImmediately
            "ApplyImmediately" -> builder.applyImmediately = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // EngineNativeAuditFieldsIncluded com.amazonaws.rds#StartActivityStreamResponse$EngineNativeAuditFieldsIncluded
            "EngineNativeAuditFieldsIncluded" -> builder.engineNativeAuditFieldsIncluded = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // KinesisStreamName com.amazonaws.rds#StartActivityStreamResponse$KinesisStreamName
            "KinesisStreamName" -> builder.kinesisStreamName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // KmsKeyId com.amazonaws.rds#StartActivityStreamResponse$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Mode com.amazonaws.rds#StartActivityStreamResponse$Mode
            "Mode" -> builder.mode = curr.tryData()
                .parse { ActivityStreamMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamMode`)" }
            // Status com.amazonaws.rds#StartActivityStreamResponse$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ActivityStreamStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
