// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.Integration
import aws.sdk.kotlin.services.rds.model.IntegrationStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeIntegrationDocument(reader: XmlTagReader): Integration {
    val builder = Integration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SourceArn com.amazonaws.rds#Integration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#SourceArn`)" }
            // TargetArn com.amazonaws.rds#Integration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#Arn`)" }
            // IntegrationName com.amazonaws.rds#Integration$IntegrationName
            "IntegrationName" -> builder.integrationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationName`)" }
            // IntegrationArn com.amazonaws.rds#Integration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationArn`)" }
            // KMSKeyId com.amazonaws.rds#Integration$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AdditionalEncryptionContext com.amazonaws.rds#Integration$AdditionalEncryptionContext
            "AdditionalEncryptionContext" -> builder.additionalEncryptionContext = deserializeEncryptionContextMapShape(curr)
            // Status com.amazonaws.rds#Integration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { IntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#IntegrationStatus`)" }
            // Tags com.amazonaws.rds#Integration$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // CreateTime com.amazonaws.rds#Integration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Errors com.amazonaws.rds#Integration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // DataFilter com.amazonaws.rds#Integration$DataFilter
            "DataFilter" -> builder.dataFilter = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#DataFilter`)" }
            // Description com.amazonaws.rds#Integration$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationDescription`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
