// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbSnapshot
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbSnapshotDocument(reader: XmlTagReader): DbSnapshot {
    val builder = DbSnapshot.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSnapshotIdentifier com.amazonaws.rds#DBSnapshot$DBSnapshotIdentifier
            "DBSnapshotIdentifier" -> builder.dbSnapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBInstanceIdentifier com.amazonaws.rds#DBSnapshot$DBInstanceIdentifier
            "DBInstanceIdentifier" -> builder.dbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SnapshotCreateTime com.amazonaws.rds#DBSnapshot$SnapshotCreateTime
            "SnapshotCreateTime" -> builder.snapshotCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Engine com.amazonaws.rds#DBSnapshot$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AllocatedStorage com.amazonaws.rds#DBSnapshot$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // Status com.amazonaws.rds#DBSnapshot$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Port com.amazonaws.rds#DBSnapshot$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // AvailabilityZone com.amazonaws.rds#DBSnapshot$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // VpcId com.amazonaws.rds#DBSnapshot$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // InstanceCreateTime com.amazonaws.rds#DBSnapshot$InstanceCreateTime
            "InstanceCreateTime" -> builder.instanceCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // MasterUsername com.amazonaws.rds#DBSnapshot$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineVersion com.amazonaws.rds#DBSnapshot$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LicenseModel com.amazonaws.rds#DBSnapshot$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SnapshotType com.amazonaws.rds#DBSnapshot$SnapshotType
            "SnapshotType" -> builder.snapshotType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Iops com.amazonaws.rds#DBSnapshot$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // OptionGroupName com.amazonaws.rds#DBSnapshot$OptionGroupName
            "OptionGroupName" -> builder.optionGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PercentProgress com.amazonaws.rds#DBSnapshot$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // SourceRegion com.amazonaws.rds#DBSnapshot$SourceRegion
            "SourceRegion" -> builder.sourceRegion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceDBSnapshotIdentifier com.amazonaws.rds#DBSnapshot$SourceDBSnapshotIdentifier
            "SourceDBSnapshotIdentifier" -> builder.sourceDbSnapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageType com.amazonaws.rds#DBSnapshot$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TdeCredentialArn com.amazonaws.rds#DBSnapshot$TdeCredentialArn
            "TdeCredentialArn" -> builder.tdeCredentialArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Encrypted com.amazonaws.rds#DBSnapshot$Encrypted
            "Encrypted" -> builder.encrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // KmsKeyId com.amazonaws.rds#DBSnapshot$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBSnapshotArn com.amazonaws.rds#DBSnapshot$DBSnapshotArn
            "DBSnapshotArn" -> builder.dbSnapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Timezone com.amazonaws.rds#DBSnapshot$Timezone
            "Timezone" -> builder.timezone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#DBSnapshot$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // ProcessorFeatures com.amazonaws.rds#DBSnapshot$ProcessorFeatures
            "ProcessorFeatures" -> builder.processorFeatures = deserializeProcessorFeatureListShape(curr)
            // DbiResourceId com.amazonaws.rds#DBSnapshot$DbiResourceId
            "DbiResourceId" -> builder.dbiResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TagList com.amazonaws.rds#DBSnapshot$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // OriginalSnapshotCreateTime com.amazonaws.rds#DBSnapshot$OriginalSnapshotCreateTime
            "OriginalSnapshotCreateTime" -> builder.originalSnapshotCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // SnapshotDatabaseTime com.amazonaws.rds#DBSnapshot$SnapshotDatabaseTime
            "SnapshotDatabaseTime" -> builder.snapshotDatabaseTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // SnapshotTarget com.amazonaws.rds#DBSnapshot$SnapshotTarget
            "SnapshotTarget" -> builder.snapshotTarget = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageThroughput com.amazonaws.rds#DBSnapshot$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBSystemId com.amazonaws.rds#DBSnapshot$DBSystemId
            "DBSystemId" -> builder.dbSystemId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DedicatedLogVolume com.amazonaws.rds#DBSnapshot$DedicatedLogVolume
            "DedicatedLogVolume" -> builder.dedicatedLogVolume = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // MultiTenant com.amazonaws.rds#DBSnapshot$MultiTenant
            "MultiTenant" -> builder.multiTenant = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
