// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamPolicyStatus
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.AutomationMode
import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.ReplicaMode
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbInstanceDocument(reader: XmlTagReader): DbInstance {
    val builder = DbInstance.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceIdentifier com.amazonaws.rds#DBInstance$DBInstanceIdentifier
            "DBInstanceIdentifier" -> builder.dbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBInstanceClass com.amazonaws.rds#DBInstance$DBInstanceClass
            "DBInstanceClass" -> builder.dbInstanceClass = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Engine com.amazonaws.rds#DBInstance$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBInstanceStatus com.amazonaws.rds#DBInstance$DBInstanceStatus
            "DBInstanceStatus" -> builder.dbInstanceStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AutomaticRestartTime com.amazonaws.rds#DBInstance$AutomaticRestartTime
            "AutomaticRestartTime" -> builder.automaticRestartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // MasterUsername com.amazonaws.rds#DBInstance$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBName com.amazonaws.rds#DBInstance$DBName
            "DBName" -> builder.dbName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Endpoint com.amazonaws.rds#DBInstance$Endpoint
            "Endpoint" -> builder.endpoint = deserializeEndpointDocument(curr)
            // AllocatedStorage com.amazonaws.rds#DBInstance$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // InstanceCreateTime com.amazonaws.rds#DBInstance$InstanceCreateTime
            "InstanceCreateTime" -> builder.instanceCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // PreferredBackupWindow com.amazonaws.rds#DBInstance$PreferredBackupWindow
            "PreferredBackupWindow" -> builder.preferredBackupWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BackupRetentionPeriod com.amazonaws.rds#DBInstance$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // DBSecurityGroups com.amazonaws.rds#DBInstance$DBSecurityGroups
            "DBSecurityGroups" -> builder.dbSecurityGroups = deserializeDBSecurityGroupMembershipListShape(curr)
            // VpcSecurityGroups com.amazonaws.rds#DBInstance$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // DBParameterGroups com.amazonaws.rds#DBInstance$DBParameterGroups
            "DBParameterGroups" -> builder.dbParameterGroups = deserializeDBParameterGroupStatusListShape(curr)
            // AvailabilityZone com.amazonaws.rds#DBInstance$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBSubnetGroup com.amazonaws.rds#DBInstance$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = deserializeDbSubnetGroupDocument(curr)
            // PreferredMaintenanceWindow com.amazonaws.rds#DBInstance$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PendingModifiedValues com.amazonaws.rds#DBInstance$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializePendingModifiedValuesDocument(curr)
            // LatestRestorableTime com.amazonaws.rds#DBInstance$LatestRestorableTime
            "LatestRestorableTime" -> builder.latestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // MultiAZ com.amazonaws.rds#DBInstance$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // EngineVersion com.amazonaws.rds#DBInstance$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AutoMinorVersionUpgrade com.amazonaws.rds#DBInstance$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // ReadReplicaSourceDBInstanceIdentifier com.amazonaws.rds#DBInstance$ReadReplicaSourceDBInstanceIdentifier
            "ReadReplicaSourceDBInstanceIdentifier" -> builder.readReplicaSourceDbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ReadReplicaDBInstanceIdentifiers com.amazonaws.rds#DBInstance$ReadReplicaDBInstanceIdentifiers
            "ReadReplicaDBInstanceIdentifiers" -> builder.readReplicaDbInstanceIdentifiers = deserializeReadReplicaDBInstanceIdentifierListShape(curr)
            // ReadReplicaDBClusterIdentifiers com.amazonaws.rds#DBInstance$ReadReplicaDBClusterIdentifiers
            "ReadReplicaDBClusterIdentifiers" -> builder.readReplicaDbClusterIdentifiers = deserializeReadReplicaDBClusterIdentifierListShape(curr)
            // ReplicaMode com.amazonaws.rds#DBInstance$ReplicaMode
            "ReplicaMode" -> builder.replicaMode = curr.tryData()
                .parse { ReplicaMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ReplicaMode`)" }
            // LicenseModel com.amazonaws.rds#DBInstance$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Iops com.amazonaws.rds#DBInstance$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // OptionGroupMemberships com.amazonaws.rds#DBInstance$OptionGroupMemberships
            "OptionGroupMemberships" -> builder.optionGroupMemberships = deserializeOptionGroupMembershipListShape(curr)
            // CharacterSetName com.amazonaws.rds#DBInstance$CharacterSetName
            "CharacterSetName" -> builder.characterSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // NcharCharacterSetName com.amazonaws.rds#DBInstance$NcharCharacterSetName
            "NcharCharacterSetName" -> builder.ncharCharacterSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SecondaryAvailabilityZone com.amazonaws.rds#DBInstance$SecondaryAvailabilityZone
            "SecondaryAvailabilityZone" -> builder.secondaryAvailabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PubliclyAccessible com.amazonaws.rds#DBInstance$PubliclyAccessible
            "PubliclyAccessible" -> builder.publiclyAccessible = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // StatusInfos com.amazonaws.rds#DBInstance$StatusInfos
            "StatusInfos" -> builder.statusInfos = deserializeDBInstanceStatusInfoListShape(curr)
            // StorageType com.amazonaws.rds#DBInstance$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TdeCredentialArn com.amazonaws.rds#DBInstance$TdeCredentialArn
            "TdeCredentialArn" -> builder.tdeCredentialArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DbInstancePort com.amazonaws.rds#DBInstance$DbInstancePort
            "DbInstancePort" -> builder.dbInstancePort = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBInstance$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageEncrypted com.amazonaws.rds#DBInstance$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // KmsKeyId com.amazonaws.rds#DBInstance$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DbiResourceId com.amazonaws.rds#DBInstance$DbiResourceId
            "DbiResourceId" -> builder.dbiResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CACertificateIdentifier com.amazonaws.rds#DBInstance$CACertificateIdentifier
            "CACertificateIdentifier" -> builder.caCertificateIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DomainMemberships com.amazonaws.rds#DBInstance$DomainMemberships
            "DomainMemberships" -> builder.domainMemberships = deserializeDomainMembershipListShape(curr)
            // CopyTagsToSnapshot com.amazonaws.rds#DBInstance$CopyTagsToSnapshot
            "CopyTagsToSnapshot" -> builder.copyTagsToSnapshot = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // MonitoringInterval com.amazonaws.rds#DBInstance$MonitoringInterval
            "MonitoringInterval" -> builder.monitoringInterval = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // EnhancedMonitoringResourceArn com.amazonaws.rds#DBInstance$EnhancedMonitoringResourceArn
            "EnhancedMonitoringResourceArn" -> builder.enhancedMonitoringResourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MonitoringRoleArn com.amazonaws.rds#DBInstance$MonitoringRoleArn
            "MonitoringRoleArn" -> builder.monitoringRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PromotionTier com.amazonaws.rds#DBInstance$PromotionTier
            "PromotionTier" -> builder.promotionTier = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBInstanceArn com.amazonaws.rds#DBInstance$DBInstanceArn
            "DBInstanceArn" -> builder.dbInstanceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Timezone com.amazonaws.rds#DBInstance$Timezone
            "Timezone" -> builder.timezone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#DBInstance$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // PerformanceInsightsEnabled com.amazonaws.rds#DBInstance$PerformanceInsightsEnabled
            "PerformanceInsightsEnabled" -> builder.performanceInsightsEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // PerformanceInsightsKMSKeyId com.amazonaws.rds#DBInstance$PerformanceInsightsKMSKeyId
            "PerformanceInsightsKMSKeyId" -> builder.performanceInsightsKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PerformanceInsightsRetentionPeriod com.amazonaws.rds#DBInstance$PerformanceInsightsRetentionPeriod
            "PerformanceInsightsRetentionPeriod" -> builder.performanceInsightsRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // EnabledCloudwatchLogsExports com.amazonaws.rds#DBInstance$EnabledCloudwatchLogsExports
            "EnabledCloudwatchLogsExports" -> builder.enabledCloudwatchLogsExports = deserializeLogTypeListShape(curr)
            // ProcessorFeatures com.amazonaws.rds#DBInstance$ProcessorFeatures
            "ProcessorFeatures" -> builder.processorFeatures = deserializeProcessorFeatureListShape(curr)
            // DeletionProtection com.amazonaws.rds#DBInstance$DeletionProtection
            "DeletionProtection" -> builder.deletionProtection = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // AssociatedRoles com.amazonaws.rds#DBInstance$AssociatedRoles
            "AssociatedRoles" -> builder.associatedRoles = deserializeDBInstanceRolesShape(curr)
            // ListenerEndpoint com.amazonaws.rds#DBInstance$ListenerEndpoint
            "ListenerEndpoint" -> builder.listenerEndpoint = deserializeEndpointDocument(curr)
            // MaxAllocatedStorage com.amazonaws.rds#DBInstance$MaxAllocatedStorage
            "MaxAllocatedStorage" -> builder.maxAllocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // TagList com.amazonaws.rds#DBInstance$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // DBInstanceAutomatedBackupsReplications com.amazonaws.rds#DBInstance$DBInstanceAutomatedBackupsReplications
            "DBInstanceAutomatedBackupsReplications" -> builder.dbInstanceAutomatedBackupsReplications = deserializeDBInstanceAutomatedBackupsReplicationListShape(curr)
            // CustomerOwnedIpEnabled com.amazonaws.rds#DBInstance$CustomerOwnedIpEnabled
            "CustomerOwnedIpEnabled" -> builder.customerOwnedIpEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // AwsBackupRecoveryPointArn com.amazonaws.rds#DBInstance$AwsBackupRecoveryPointArn
            "AwsBackupRecoveryPointArn" -> builder.awsBackupRecoveryPointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ActivityStreamStatus com.amazonaws.rds#DBInstance$ActivityStreamStatus
            "ActivityStreamStatus" -> builder.activityStreamStatus = curr.tryData()
                .parse { ActivityStreamStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamStatus`)" }
            // ActivityStreamKmsKeyId com.amazonaws.rds#DBInstance$ActivityStreamKmsKeyId
            "ActivityStreamKmsKeyId" -> builder.activityStreamKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ActivityStreamKinesisStreamName com.amazonaws.rds#DBInstance$ActivityStreamKinesisStreamName
            "ActivityStreamKinesisStreamName" -> builder.activityStreamKinesisStreamName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ActivityStreamMode com.amazonaws.rds#DBInstance$ActivityStreamMode
            "ActivityStreamMode" -> builder.activityStreamMode = curr.tryData()
                .parse { ActivityStreamMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamMode`)" }
            // ActivityStreamEngineNativeAuditFieldsIncluded com.amazonaws.rds#DBInstance$ActivityStreamEngineNativeAuditFieldsIncluded
            "ActivityStreamEngineNativeAuditFieldsIncluded" -> builder.activityStreamEngineNativeAuditFieldsIncluded = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // AutomationMode com.amazonaws.rds#DBInstance$AutomationMode
            "AutomationMode" -> builder.automationMode = curr.tryData()
                .parse { AutomationMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#AutomationMode`)" }
            // ResumeFullAutomationModeTime com.amazonaws.rds#DBInstance$ResumeFullAutomationModeTime
            "ResumeFullAutomationModeTime" -> builder.resumeFullAutomationModeTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // CustomIamInstanceProfile com.amazonaws.rds#DBInstance$CustomIamInstanceProfile
            "CustomIamInstanceProfile" -> builder.customIamInstanceProfile = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BackupTarget com.amazonaws.rds#DBInstance$BackupTarget
            "BackupTarget" -> builder.backupTarget = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // NetworkType com.amazonaws.rds#DBInstance$NetworkType
            "NetworkType" -> builder.networkType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ActivityStreamPolicyStatus com.amazonaws.rds#DBInstance$ActivityStreamPolicyStatus
            "ActivityStreamPolicyStatus" -> builder.activityStreamPolicyStatus = curr.tryData()
                .parse { ActivityStreamPolicyStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamPolicyStatus`)" }
            // StorageThroughput com.amazonaws.rds#DBInstance$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBSystemId com.amazonaws.rds#DBInstance$DBSystemId
            "DBSystemId" -> builder.dbSystemId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MasterUserSecret com.amazonaws.rds#DBInstance$MasterUserSecret
            "MasterUserSecret" -> builder.masterUserSecret = deserializeMasterUserSecretDocument(curr)
            // CertificateDetails com.amazonaws.rds#DBInstance$CertificateDetails
            "CertificateDetails" -> builder.certificateDetails = deserializeCertificateDetailsDocument(curr)
            // ReadReplicaSourceDBClusterIdentifier com.amazonaws.rds#DBInstance$ReadReplicaSourceDBClusterIdentifier
            "ReadReplicaSourceDBClusterIdentifier" -> builder.readReplicaSourceDbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PercentProgress com.amazonaws.rds#DBInstance$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DedicatedLogVolume com.amazonaws.rds#DBInstance$DedicatedLogVolume
            "DedicatedLogVolume" -> builder.dedicatedLogVolume = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // IsStorageConfigUpgradeAvailable com.amazonaws.rds#DBInstance$IsStorageConfigUpgradeAvailable
            "IsStorageConfigUpgradeAvailable" -> builder.isStorageConfigUpgradeAvailable = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // MultiTenant com.amazonaws.rds#DBInstance$MultiTenant
            "MultiTenant" -> builder.multiTenant = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // EngineLifecycleSupport com.amazonaws.rds#DBInstance$EngineLifecycleSupport
            "EngineLifecycleSupport" -> builder.engineLifecycleSupport = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
