// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbEngineVersion
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbEngineVersionDocument(reader: XmlTagReader): DbEngineVersion {
    val builder = DbEngineVersion.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Engine com.amazonaws.rds#DBEngineVersion$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineVersion com.amazonaws.rds#DBEngineVersion$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBParameterGroupFamily com.amazonaws.rds#DBEngineVersion$DBParameterGroupFamily
            "DBParameterGroupFamily" -> builder.dbParameterGroupFamily = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineDescription com.amazonaws.rds#DBEngineVersion$DBEngineDescription
            "DBEngineDescription" -> builder.dbEngineDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineVersionDescription com.amazonaws.rds#DBEngineVersion$DBEngineVersionDescription
            "DBEngineVersionDescription" -> builder.dbEngineVersionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DefaultCharacterSet com.amazonaws.rds#DBEngineVersion$DefaultCharacterSet
            "DefaultCharacterSet" -> builder.defaultCharacterSet = deserializeCharacterSetDocument(curr)
            // Image com.amazonaws.rds#DBEngineVersion$Image
            "Image" -> builder.image = deserializeCustomDbEngineVersionAmiDocument(curr)
            // DBEngineMediaType com.amazonaws.rds#DBEngineVersion$DBEngineMediaType
            "DBEngineMediaType" -> builder.dbEngineMediaType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SupportedCharacterSets com.amazonaws.rds#DBEngineVersion$SupportedCharacterSets
            "SupportedCharacterSets" -> builder.supportedCharacterSets = deserializeSupportedCharacterSetsListShape(curr)
            // SupportedNcharCharacterSets com.amazonaws.rds#DBEngineVersion$SupportedNcharCharacterSets
            "SupportedNcharCharacterSets" -> builder.supportedNcharCharacterSets = deserializeSupportedCharacterSetsListShape(curr)
            // ValidUpgradeTarget com.amazonaws.rds#DBEngineVersion$ValidUpgradeTarget
            "ValidUpgradeTarget" -> builder.validUpgradeTarget = deserializeValidUpgradeTargetListShape(curr)
            // SupportedTimezones com.amazonaws.rds#DBEngineVersion$SupportedTimezones
            "SupportedTimezones" -> builder.supportedTimezones = deserializeSupportedTimezonesListShape(curr)
            // ExportableLogTypes com.amazonaws.rds#DBEngineVersion$ExportableLogTypes
            "ExportableLogTypes" -> builder.exportableLogTypes = deserializeLogTypeListShape(curr)
            // SupportsLogExportsToCloudwatchLogs com.amazonaws.rds#DBEngineVersion$SupportsLogExportsToCloudwatchLogs
            "SupportsLogExportsToCloudwatchLogs" -> builder.supportsLogExportsToCloudwatchLogs = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsReadReplica com.amazonaws.rds#DBEngineVersion$SupportsReadReplica
            "SupportsReadReplica" -> builder.supportsReadReplica = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportedEngineModes com.amazonaws.rds#DBEngineVersion$SupportedEngineModes
            "SupportedEngineModes" -> builder.supportedEngineModes = deserializeEngineModeListShape(curr)
            // SupportedFeatureNames com.amazonaws.rds#DBEngineVersion$SupportedFeatureNames
            "SupportedFeatureNames" -> builder.supportedFeatureNames = deserializeFeatureNameListShape(curr)
            // Status com.amazonaws.rds#DBEngineVersion$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SupportsParallelQuery com.amazonaws.rds#DBEngineVersion$SupportsParallelQuery
            "SupportsParallelQuery" -> builder.supportsParallelQuery = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsGlobalDatabases com.amazonaws.rds#DBEngineVersion$SupportsGlobalDatabases
            "SupportsGlobalDatabases" -> builder.supportsGlobalDatabases = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // MajorEngineVersion com.amazonaws.rds#DBEngineVersion$MajorEngineVersion
            "MajorEngineVersion" -> builder.majorEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DatabaseInstallationFilesS3BucketName com.amazonaws.rds#DBEngineVersion$DatabaseInstallationFilesS3BucketName
            "DatabaseInstallationFilesS3BucketName" -> builder.databaseInstallationFilesS3BucketName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DatabaseInstallationFilesS3Prefix com.amazonaws.rds#DBEngineVersion$DatabaseInstallationFilesS3Prefix
            "DatabaseInstallationFilesS3Prefix" -> builder.databaseInstallationFilesS3Prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBEngineVersionArn com.amazonaws.rds#DBEngineVersion$DBEngineVersionArn
            "DBEngineVersionArn" -> builder.dbEngineVersionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // KMSKeyId com.amazonaws.rds#DBEngineVersion$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CreateTime com.amazonaws.rds#DBEngineVersion$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TagList com.amazonaws.rds#DBEngineVersion$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // SupportsBabelfish com.amazonaws.rds#DBEngineVersion$SupportsBabelfish
            "SupportsBabelfish" -> builder.supportsBabelfish = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // CustomDBEngineVersionManifest com.amazonaws.rds#DBEngineVersion$CustomDBEngineVersionManifest
            "CustomDBEngineVersionManifest" -> builder.customDbEngineVersionManifest = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#CustomDBEngineVersionManifest`)" }
            // SupportsLimitlessDatabase com.amazonaws.rds#DBEngineVersion$SupportsLimitlessDatabase
            "SupportsLimitlessDatabase" -> builder.supportsLimitlessDatabase = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // SupportsCertificateRotationWithoutRestart com.amazonaws.rds#DBEngineVersion$SupportsCertificateRotationWithoutRestart
            "SupportsCertificateRotationWithoutRestart" -> builder.supportsCertificateRotationWithoutRestart = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // SupportedCACertificateIdentifiers com.amazonaws.rds#DBEngineVersion$SupportedCACertificateIdentifiers
            "SupportedCACertificateIdentifiers" -> builder.supportedCaCertificateIdentifiers = deserializeCACertificateIdentifiersListShape(curr)
            // SupportsLocalWriteForwarding com.amazonaws.rds#DBEngineVersion$SupportsLocalWriteForwarding
            "SupportsLocalWriteForwarding" -> builder.supportsLocalWriteForwarding = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // SupportsIntegrations com.amazonaws.rds#DBEngineVersion$SupportsIntegrations
            "SupportsIntegrations" -> builder.supportsIntegrations = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
