// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbClusterBacktrack
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterBacktrackDocument(reader: XmlTagReader): DbClusterBacktrack {
    val builder = DbClusterBacktrack.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterIdentifier com.amazonaws.rds#DBClusterBacktrack$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BacktrackIdentifier com.amazonaws.rds#DBClusterBacktrack$BacktrackIdentifier
            "BacktrackIdentifier" -> builder.backtrackIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BacktrackTo com.amazonaws.rds#DBClusterBacktrack$BacktrackTo
            "BacktrackTo" -> builder.backtrackTo = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // BacktrackedFrom com.amazonaws.rds#DBClusterBacktrack$BacktrackedFrom
            "BacktrackedFrom" -> builder.backtrackedFrom = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // BacktrackRequestCreationTime com.amazonaws.rds#DBClusterBacktrack$BacktrackRequestCreationTime
            "BacktrackRequestCreationTime" -> builder.backtrackRequestCreationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Status com.amazonaws.rds#DBClusterBacktrack$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
