// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbClusterAutomatedBackup
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterAutomatedBackupDocument(reader: XmlTagReader): DbClusterAutomatedBackup {
    val builder = DbClusterAutomatedBackup.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Engine com.amazonaws.rds#DBClusterAutomatedBackup$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // VpcId com.amazonaws.rds#DBClusterAutomatedBackup$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterAutomatedBackupsArn com.amazonaws.rds#DBClusterAutomatedBackup$DBClusterAutomatedBackupsArn
            "DBClusterAutomatedBackupsArn" -> builder.dbClusterAutomatedBackupsArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBClusterAutomatedBackup$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // RestoreWindow com.amazonaws.rds#DBClusterAutomatedBackup$RestoreWindow
            "RestoreWindow" -> builder.restoreWindow = deserializeRestoreWindowDocument(curr)
            // MasterUsername com.amazonaws.rds#DBClusterAutomatedBackup$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DbClusterResourceId com.amazonaws.rds#DBClusterAutomatedBackup$DbClusterResourceId
            "DbClusterResourceId" -> builder.dbClusterResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Region com.amazonaws.rds#DBClusterAutomatedBackup$Region
            "Region" -> builder.region = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LicenseModel com.amazonaws.rds#DBClusterAutomatedBackup$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBClusterAutomatedBackup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#DBClusterAutomatedBackup$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // ClusterCreateTime com.amazonaws.rds#DBClusterAutomatedBackup$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // StorageEncrypted com.amazonaws.rds#DBClusterAutomatedBackup$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // AllocatedStorage com.amazonaws.rds#DBClusterAutomatedBackup$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // EngineVersion com.amazonaws.rds#DBClusterAutomatedBackup$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterArn com.amazonaws.rds#DBClusterAutomatedBackup$DBClusterArn
            "DBClusterArn" -> builder.dbClusterArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BackupRetentionPeriod com.amazonaws.rds#DBClusterAutomatedBackup$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // EngineMode com.amazonaws.rds#DBClusterAutomatedBackup$EngineMode
            "EngineMode" -> builder.engineMode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AvailabilityZones com.amazonaws.rds#DBClusterAutomatedBackup$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // Port com.amazonaws.rds#DBClusterAutomatedBackup$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // KmsKeyId com.amazonaws.rds#DBClusterAutomatedBackup$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageType com.amazonaws.rds#DBClusterAutomatedBackup$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Iops com.amazonaws.rds#DBClusterAutomatedBackup$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // AwsBackupRecoveryPointArn com.amazonaws.rds#DBClusterAutomatedBackup$AwsBackupRecoveryPointArn
            "AwsBackupRecoveryPointArn" -> builder.awsBackupRecoveryPointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageThroughput com.amazonaws.rds#DBClusterAutomatedBackup$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
