// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbSecurityGroupResponse
import aws.sdk.kotlin.services.rds.model.DbSecurityGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBSecurityGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateDbSecurityGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDbSecurityGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbSecurityGroupError(context, call, payload)
        }
        val builder = CreateDbSecurityGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateDBSecurityGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDbSecurityGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSecurityGroupNotSupported" -> DbSecurityGroupNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSecurityGroupAlreadyExists" -> DbSecurityGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "QuotaExceeded.DBSecurityGroup" -> DbSecurityGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBSecurityGroupOperationBody(builder: CreateDbSecurityGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBSecurityGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSecurityGroup com.amazonaws.rds#CreateDBSecurityGroupResult$DBSecurityGroup
            "DBSecurityGroup" -> builder.dbSecurityGroup = deserializeDbSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
