// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointResponse
import aws.sdk.kotlin.services.rds.model.DbProxyEndpoint
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBProxyEndpointOperationDeserializer: HttpDeserializer.NonStreaming<CreateDbProxyEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDbProxyEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbProxyEndpointError(context, call, payload)
        }
        val builder = CreateDbProxyEndpointResponse.Builder()

        if (payload != null) {
            deserializeCreateDBProxyEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDbProxyEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyEndpointAlreadyExistsFault" -> DbProxyEndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBProxyEndpointQuotaExceededFault" -> DbProxyEndpointQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBProxyStateFault" -> InvalidDbProxyStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBProxyEndpointOperationBody(builder: CreateDbProxyEndpointResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBProxyEndpoint")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyEndpoint com.amazonaws.rds#CreateDBProxyEndpointResponse$DBProxyEndpoint
            "DBProxyEndpoint" -> builder.dbProxyEndpoint = deserializeDbProxyEndpointDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
