// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaResponse
import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBInstanceReadReplicaOperationDeserializer: HttpDeserializer.NonStreaming<CreateDbInstanceReadReplicaResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDbInstanceReadReplicaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbInstanceReadReplicaError(context, call, payload)
        }
        val builder = CreateDbInstanceReadReplicaResponse.Builder()

        if (payload != null) {
            deserializeCreateDBInstanceReadReplicaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDbInstanceReadReplicaError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSubnetGroupFault" -> InvalidDbSubnetGroupFaultDeserializer().deserialize(context, wrappedCall, payload)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotAllowedFault" -> DbSubnetGroupNotAllowedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "TenantDatabaseQuotaExceeded" -> TenantDatabaseQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDBInstanceCapacity" -> InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CertificateNotFound" -> CertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NetworkTypeNotSupported" -> NetworkTypeNotSupportedDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DomainNotFoundFault" -> DomainNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedIopsNotAvailableInAZFault" -> ProvisionedIopsNotAvailableInAzFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBInstanceReadReplicaOperationBody(builder: CreateDbInstanceReadReplicaResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBInstanceReadReplica")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstance com.amazonaws.rds#CreateDBInstanceReadReplicaResult$DBInstance
            "DBInstance" -> builder.dbInstance = deserializeDbInstanceDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
