// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BlueGreenDeployment
import aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateBlueGreenDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<CreateBlueGreenDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateBlueGreenDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateBlueGreenDeploymentError(context, call, payload)
        }
        val builder = CreateBlueGreenDeploymentResponse.Builder()

        if (payload != null) {
            deserializeCreateBlueGreenDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateBlueGreenDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SourceDatabaseNotSupportedFault" -> SourceDatabaseNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "BlueGreenDeploymentAlreadyExistsFault" -> BlueGreenDeploymentAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SourceClusterNotSupportedFault" -> SourceClusterNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBlueGreenDeploymentOperationBody(builder: CreateBlueGreenDeploymentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateBlueGreenDeployment")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BlueGreenDeployment com.amazonaws.rds#CreateBlueGreenDeploymentResponse$BlueGreenDeployment
            "BlueGreenDeployment" -> builder.blueGreenDeployment = deserializeBlueGreenDeploymentDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
