// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CopyDbSnapshotRequest
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CopyDBSnapshotOperationSerializer: HttpSerializer.NonStreaming<CopyDbSnapshotRequest> {
    override fun serialize(context: ExecutionContext, input: CopyDbSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCopyDBSnapshotOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCopyDBSnapshotOperationBody(context: ExecutionContext, input: CopyDbSnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val COPYOPTIONGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyOptionGroup"))
    val COPYTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyTags"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val OPTIONGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OptionGroupName"))
    val PRESIGNEDURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreSignedUrl"))
    val SOURCEDBSNAPSHOTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceDBSnapshotIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val TARGETCUSTOMAVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetCustomAvailabilityZone"))
    val TARGETDBSNAPSHOTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetDBSnapshotIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CopyDBSnapshotMessage"))
        trait(QueryLiteral("Action", "CopyDBSnapshot"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(COPYOPTIONGROUP_DESCRIPTOR)
        field(COPYTAGS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(OPTIONGROUPNAME_DESCRIPTOR)
        field(PRESIGNEDURL_DESCRIPTOR)
        field(SOURCEDBSNAPSHOTIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETCUSTOMAVAILABILITYZONE_DESCRIPTOR)
        field(TARGETDBSNAPSHOTIDENTIFIER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.copyOptionGroup?.let { field(COPYOPTIONGROUP_DESCRIPTOR, it) }
        input.copyTags?.let { field(COPYTAGS_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.optionGroupName?.let { field(OPTIONGROUPNAME_DESCRIPTOR, it) }
        input.preSignedUrl?.let { field(PRESIGNEDURL_DESCRIPTOR, it) }
        input.sourceDbSnapshotIdentifier?.let { field(SOURCEDBSNAPSHOTIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.targetCustomAvailabilityZone?.let { field(TARGETCUSTOMAVAILABILITYZONE_DESCRIPTOR, it) }
        input.targetDbSnapshotIdentifier?.let { field(TARGETDBSNAPSHOTIDENTIFIER_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
