// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CopyDbParameterGroupResponse
import aws.sdk.kotlin.services.rds.model.DbParameterGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CopyDBParameterGroupOperationDeserializer: HttpDeserializer.NonStreaming<CopyDbParameterGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CopyDbParameterGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCopyDbParameterGroupError(context, call, payload)
        }
        val builder = CopyDbParameterGroupResponse.Builder()

        if (payload != null) {
            deserializeCopyDBParameterGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCopyDbParameterGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBParameterGroupAlreadyExists" -> DbParameterGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupQuotaExceeded" -> DbParameterGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopyDBParameterGroupOperationBody(builder: CopyDbParameterGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CopyDBParameterGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBParameterGroup com.amazonaws.rds#CopyDBParameterGroupResult$DBParameterGroup
            "DBParameterGroup" -> builder.dbParameterGroup = deserializeDbParameterGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
