// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CopyDbClusterSnapshotResponse
import aws.sdk.kotlin.services.rds.model.DbClusterSnapshot
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CopyDBClusterSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CopyDbClusterSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CopyDbClusterSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCopyDbClusterSnapshotError(context, call, payload)
        }
        val builder = CopyDbClusterSnapshotResponse.Builder()

        if (payload != null) {
            deserializeCopyDBClusterSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCopyDbClusterSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotQuotaExceeded" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterSnapshotAlreadyExistsFault" -> DbClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopyDBClusterSnapshotOperationBody(builder: CopyDbClusterSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CopyDBClusterSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterSnapshot com.amazonaws.rds#CopyDBClusterSnapshotResult$DBClusterSnapshot
            "DBClusterSnapshot" -> builder.dbClusterSnapshot = deserializeDbClusterSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
