// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BacktrackDbClusterRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class BacktrackDBClusterOperationSerializer: HttpSerializer.NonStreaming<BacktrackDbClusterRequest> {
    override fun serialize(context: ExecutionContext, input: BacktrackDbClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeBacktrackDBClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeBacktrackDBClusterOperationBody(context: ExecutionContext, input: BacktrackDbClusterRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val BACKTRACKTO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("BacktrackTo"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBClusterIdentifier"))
    val FORCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Force"))
    val USEEARLIESTTIMEONPOINTINTIMEUNAVAILABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UseEarliestTimeOnPointInTimeUnavailable"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("BacktrackDBClusterMessage"))
        trait(QueryLiteral("Action", "BacktrackDBCluster"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(BACKTRACKTO_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(FORCE_DESCRIPTOR)
        field(USEEARLIESTTIMEONPOINTINTIMEUNAVAILABLE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backtrackTo?.let { field(BACKTRACKTO_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.dbClusterIdentifier?.let { field(DBCLUSTERIDENTIFIER_DESCRIPTOR, it) }
        input.force?.let { field(FORCE_DESCRIPTOR, it) }
        input.useEarliestTimeOnPointInTimeUnavailable?.let { field(USEEARLIESTTIMEONPOINTINTIMEUNAVAILABLE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
