// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ApplyPendingMaintenanceActionResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.ResourcePendingMaintenanceActions
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ApplyPendingMaintenanceActionOperationDeserializer: HttpDeserializer.NonStreaming<ApplyPendingMaintenanceActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ApplyPendingMaintenanceActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwApplyPendingMaintenanceActionError(context, call, payload)
        }
        val builder = ApplyPendingMaintenanceActionResponse.Builder()

        if (payload != null) {
            deserializeApplyPendingMaintenanceActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwApplyPendingMaintenanceActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeApplyPendingMaintenanceActionOperationBody(builder: ApplyPendingMaintenanceActionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ApplyPendingMaintenanceAction")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ResourcePendingMaintenanceActions com.amazonaws.rds#ApplyPendingMaintenanceActionResult$ResourcePendingMaintenanceActions
            "ResourcePendingMaintenanceActions" -> builder.resourcePendingMaintenanceActions = deserializeResourcePendingMaintenanceActionsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
